/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command.dom;

import java.util.Map;
import org.structr.web.entity.dom.DOMNode;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.DOMException;

public class InsertBeforeCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String id = webSocketData.getId();
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String refId = (String)nodeData.get("refId");
        String parentId = (String)nodeData.get("parentId");
        if (id == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("No node to append").build(), true);
            return;
        }
        if (parentId == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot add node without parentId").build(), true);
            return;
        }
        DOMNode refNode = this.getDOMNode(refId);
        DOMNode parentNode = this.getDOMNode(parentId);
        if (parentNode == null) {
            this.getWebSocket().send(MessageBuilder.status().code(404).message("Parent node not found").build(), true);
            return;
        }
        DOMNode node = this.getDOMNode(id);
        try {
            if (node != null) {
                parentNode.insertBefore(node, refNode);
            }
        }
        catch (DOMException dex) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message(dex.getMessage()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "INSERT_BEFORE";
    }

    static {
        StructrWebSocket.addCommand(InsertBeforeCommand.class);
    }
}

