/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.servlet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.structr.api.config.Settings;
import org.structr.core.StructrTransactionListener;
import org.structr.core.graph.TransactionCommand;
import org.structr.rest.service.HttpServiceServlet;
import org.structr.rest.service.StructrHttpServiceConfig;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.StructrWebSocketCreator;
import org.structr.websocket.WebSocketDataGSONAdapter;
import org.structr.websocket.WebsocketController;
import org.structr.websocket.message.WebSocketMessage;

public class WebSocketServlet
extends org.eclipse.jetty.websocket.servlet.WebSocketServlet
implements HttpServiceServlet {
    private static final int MAX_TEXT_MESSAGE_SIZE = 0x100000;
    private final StructrHttpServiceConfig config = new StructrHttpServiceConfig();

    public StructrHttpServiceConfig getConfig() {
        return this.config;
    }

    public String getModuleName() {
        return "ui";
    }

    public void configure(WebSocketServletFactory factory) {
        boolean lenient;
        GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls().registerTypeAdapter(WebSocketMessage.class, (Object)new WebSocketDataGSONAdapter(this.config.getOutputNestingDepth()));
        if (((Boolean)Settings.WsIndentation.getValue()).booleanValue()) {
            gsonBuilder.setPrettyPrinting();
        }
        if (lenient = ((Boolean)Settings.JsonLenient.getValue()).booleanValue()) {
            gsonBuilder.serializeSpecialFloatingPointValues();
        }
        Gson gson = gsonBuilder.create();
        WebsocketController syncController = new WebsocketController(gson);
        TransactionCommand.registerTransactionListener((StructrTransactionListener)syncController);
        factory.getPolicy().setIdleTimeout(61000L);
        factory.setCreator((WebSocketCreator)new StructrWebSocketCreator(syncController, gson, this.config.getAuthenticator()));
        factory.register(StructrWebSocket.class);
        factory.getExtensionFactory().unregister("x-webkit-deflate-frame");
        factory.getExtensionFactory().unregister("permessage-deflate");
        factory.getPolicy().setMaxTextMessageSize(0x100000);
    }
}

