/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.rest;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.error.FrameworkException;
import org.structr.console.Console;
import org.structr.console.rest.RestCommand;
import org.structr.util.Writable;

public class AsRestCommand
extends RestCommand {
    private RestCommand command = null;

    @Override
    public void run(Console console, Writable writable) throws FrameworkException, IOException {
        this.command.run(console, writable);
    }

    @Override
    public boolean parseNext(String line, Writable writable) throws IOException {
        String trimmed = line.trim();
        String userString = StringUtils.substringBefore((String)trimmed, (String)" ");
        String remaining = StringUtils.substringAfter((String)trimmed, (String)" ");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{userString, remaining})) {
            this.command = RestCommand.parse(remaining, writable);
            if (this.command != null) {
                String[] parts = userString.split("[:]+");
                if (parts.length == 2) {
                    this.command.authenticate(parts[0], parts[1]);
                    return true;
                }
                writable.println(new Object[]{"Syntax error, user string must be <username>:<password>."});
            }
        } else {
            writable.println(new Object[]{"Syntax error, user string must be <username>:<password>."});
        }
        return false;
    }

    @Override
    public void commandHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"Runs a REST command in the security context of a given user."});
    }

    @Override
    public void detailHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"as <user:password> <command> - Runs the given command as the given user."});
    }

    static {
        RestCommand.registerCommand("as", AsRestCommand.class);
    }
}

