/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.shell;

import java.io.IOException;
import java.util.List;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.console.shell.AdminConsoleCommand;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.Principal;
import org.structr.util.Writable;
import org.structr.web.maintenance.DeployCommand;

public class ImportConsoleCommand
extends AdminConsoleCommand {
    @Override
    public void run(SecurityContext securityContext, List<String> parameters, Writable writable) throws FrameworkException, IOException {
        Principal user = securityContext.getUser(false);
        if (user != null && user.isAdmin()) {
            DeployCommand cmd = (DeployCommand)StructrApp.getInstance((SecurityContext)securityContext).command(DeployCommand.class);
            cmd.setLogBuffer(writable);
            cmd.execute(this.toMap("mode", "import", "source", this.getParameter(parameters, 1)));
        } else {
            writable.println(new Object[]{"You must be admin user to use this command."});
        }
    }

    @Override
    public void commandHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"Imports a Structr application from a directory."});
    }

    @Override
    public void detailHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"import <source> - imports an application from the given source directory."});
    }

    @Override
    public boolean requiresEnclosingTransaction() {
        return false;
    }

    static {
        AdminConsoleCommand.registerCommand("import", ImportConsoleCommand.class);
    }
}

