/*
 * Decompiled with CFR 0.152.
 */
package org.structr.console.shell;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.console.shell.AdminConsoleCommand;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.util.Writable;

public class UserConsoleCommand
extends AdminConsoleCommand {
    @Override
    public void run(SecurityContext securityContext, List<String> parameters, Writable writable) throws FrameworkException, IOException {
        String command = this.getParameter(parameters, 1);
        if (command != null) {
            Principal user = securityContext.getUser(false);
            if (user != null && user.isAdmin()) {
                switch (command) {
                    case "list": {
                        this.handleList(securityContext, writable);
                        break;
                    }
                    case "add": {
                        this.handleAdd(securityContext, writable, this.getParameter(parameters, 2), this.getParameter(parameters, 3), this.getParameter(parameters, 4));
                        break;
                    }
                    case "delete": {
                        this.handleDelete(securityContext, writable, this.getParameter(parameters, 2), this.getParameter(parameters, 3));
                        break;
                    }
                    case "password": {
                        this.handlePwd(securityContext, writable, this.getParameter(parameters, 2), this.getParameter(parameters, 3));
                    }
                }
            } else {
                writable.println(new Object[]{"You must be admin user to use this command."});
            }
        } else {
            writable.println(new Object[]{"Missing command, must be one of 'list', 'add', 'delete' or 'password'."});
        }
    }

    @Override
    public void commandHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"Creates and deletes users, sets passwords."});
    }

    @Override
    public void detailHelp(Writable writable) throws IOException {
        writable.println(new Object[]{"user list                          - lists all user in the database"});
        writable.println(new Object[]{"user add <name> [<e-mail>|isAdmin] - adds a new user with the given name and optional e-mail address"});
        writable.println(new Object[]{"user delete <name>                 - deletes the user with the given name"});
        writable.println(new Object[]{"user password <name> <password>    - sets the password for the given user"});
    }

    private void handleList(SecurityContext securityContext, Writable writable) throws FrameworkException, IOException {
        Class type = StructrApp.getConfiguration().getNodeEntityClass("User");
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        if (type != null) {
            try (Tx tx = app.tx();){
                List users = app.nodeQuery(type).getAsList();
                Iterator it = users.iterator();
                while (it.hasNext()) {
                    NodeInterface user = (NodeInterface)it.next();
                    String name = (String)user.getProperty((PropertyKey)AbstractNode.name);
                    if (name != null) {
                        writable.print(new Object[]{name});
                    } else {
                        writable.print(new Object[]{user.getUuid()});
                    }
                    if (!it.hasNext()) continue;
                    writable.print(new Object[]{", "});
                }
                writable.println();
                tx.success();
            }
        } else {
            throw new FrameworkException(422, "Cannot list users, no User class found.");
        }
    }

    private void handleAdd(SecurityContext securityContext, Writable writable, String name, String eMail, String isAdmin) throws FrameworkException, IOException {
        if (StringUtils.isEmpty((String)name)) {
            throw new FrameworkException(422, "Missing user name for add command.");
        }
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        Class type = StructrApp.getConfiguration().getNodeEntityClass("User");
        if (type != null) {
            try (Tx tx = app.tx();){
                NodeInterface user = app.create(type, new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractNode.name, (Object)name)});
                if (eMail != null && !"isAdmin".equals(eMail)) {
                    user.setProperties(securityContext, new PropertyMap((PropertyKey)Principal.eMail, (Object)eMail));
                }
                if ("isAdmin".equals(eMail) || "isAdmin".equals(isAdmin)) {
                    user.setProperties(securityContext, new PropertyMap((PropertyKey)Principal.isAdmin, (Object)true));
                }
                writable.println(new Object[]{"User created."});
                tx.success();
            }
        } else {
            throw new FrameworkException(422, "Cannot create user, no User class found.");
        }
    }

    private void handleDelete(SecurityContext securityContext, Writable writable, String name, String confirm) throws FrameworkException, IOException {
        if (StringUtils.isEmpty((String)name)) {
            throw new FrameworkException(422, "Missing user name for delete command.");
        }
        Class type = StructrApp.getConfiguration().getNodeEntityClass("User");
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        if (type != null) {
            try (Tx tx = app.tx();){
                NodeInterface user = (NodeInterface)app.nodeQuery(type).andName(name).getFirst();
                if (user == null) {
                    user = (NodeInterface)app.get(type, name);
                }
                if (user != null) {
                    if (((List)user.getProperty((PropertyKey)Principal.ownedNodes)).isEmpty()) {
                        app.delete(user);
                        writable.println(new Object[]{"User deleted."});
                    } else {
                        String hash = user.getUuid().substring(7, 11);
                        if (confirm == null || !confirm.equals(hash)) {
                            writable.print(new Object[]{"User '"});
                            writable.print(new Object[]{name});
                            writable.print(new Object[]{"' has owned nodes, please confirm deletion with 'user delete "});
                            writable.print(new Object[]{name});
                            writable.print(new Object[]{" "});
                            writable.print(new Object[]{hash});
                            writable.println(new Object[]{"'."});
                        } else {
                            app.delete(user);
                            writable.println(new Object[]{"User deleted."});
                        }
                    }
                } else {
                    throw new FrameworkException(422, "User " + name + " not found.");
                }
                tx.success();
            }
        } else {
            throw new FrameworkException(422, "Cannot delete user, no User class found.");
        }
    }

    private void handlePwd(SecurityContext securityContext, Writable writable, String name, String password) throws FrameworkException, IOException {
        if (StringUtils.isEmpty((String)name)) {
            throw new FrameworkException(422, "Missing user name for password command.");
        }
        Class type = StructrApp.getConfiguration().getNodeEntityClass("User");
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        if (type != null) {
            try (Tx tx = app.tx();){
                NodeInterface user = (NodeInterface)app.nodeQuery(type).andName(name).getFirst();
                if (user != null) {
                    if (!StringUtils.isNotBlank((String)password)) {
                        throw new FrameworkException(422, "Will not set empty password");
                    }
                } else {
                    throw new FrameworkException(422, "User " + name + " not found.");
                }
                user.setProperties(securityContext, new PropertyMap((PropertyKey)Principal.password, (Object)password));
                writable.println(new Object[]{"Password changed."});
                tx.success();
            }
        } else {
            throw new FrameworkException(422, "Cannot change password, no User class found.");
        }
    }

    static {
        AdminConsoleCommand.registerCommand("user", UserConsoleCommand.class);
    }
}

