/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.cmis;

import java.util.Map;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.slf4j.Logger;
import org.structr.cmis.CMISInfo;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.files.cmis.StructrCMISService;

public abstract class AbstractStructrCmisService {
    public StructrCMISService parentService = null;
    public SecurityContext securityContext = null;

    public AbstractStructrCmisService(StructrCMISService parentService, SecurityContext securityContext) {
        this.parentService = parentService;
        this.securityContext = securityContext;
    }

    public void log(Logger logger, Object ... objects) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < objects.length; ++i) {
            buf.append("\n{").append(i).append("}");
        }
        logger.info(buf.toString(), objects);
    }

    public Object getValue(Properties properties, String key) {
        PropertyData value;
        Map data = properties.getProperties();
        if (data != null && (value = (PropertyData)data.get(key)) != null) {
            return value.getFirstValue();
        }
        return null;
    }

    public String getStringValue(Properties properties, String key) {
        Object value = this.getValue(properties, key);
        if (value != null && value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public CMISInfo getCMISInfo(Class<? extends GraphObject> type) {
        try {
            return type.newInstance().getCMISInfo();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public BaseTypeId getBaseTypeId(Class<? extends GraphObject> type) {
        CMISInfo info = this.getCMISInfo(type);
        if (info != null) {
            return info.getBaseTypeId();
        }
        return null;
    }

    public BaseTypeId getBaseTypeId(String typeId) {
        try {
            return BaseTypeId.fromValue((String)typeId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public Class typeFromObjectTypeId(String objectTypeId, BaseTypeId defaultType, Class defaultClass) {
        if (defaultType.value().equals(objectTypeId)) {
            return defaultClass;
        }
        return StructrApp.getConfiguration().getNodeEntityClass(objectTypeId);
    }
}

