/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.cmis;

import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.enums.AclPropagation;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.spi.AclService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.cmis.wrapper.CMISObjectWrapper;
import org.structr.common.AccessControllable;
import org.structr.common.Permission;
import org.structr.common.Permissions;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.files.cmis.AbstractStructrCmisService;
import org.structr.files.cmis.StructrCMISService;

public class CMISAclService
extends AbstractStructrCmisService
implements AclService {
    private static final Logger logger = LoggerFactory.getLogger((String)CMISAclService.class.getName());

    public CMISAclService(StructrCMISService parentService, SecurityContext securityContext) {
        super(parentService, securityContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Acl getAcl(String repositoryId, String objectId, Boolean onlyBasicPermissions, ExtensionsData extension) {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        try (Tx tx = app.tx();){
            GraphObject node = app.get(objectId);
            if (node != null) {
                CMISObjectWrapper cMISObjectWrapper = CMISObjectWrapper.wrap((GraphObject)node, null, (Boolean)false);
                return cMISObjectWrapper;
            }
            tx.success();
            throw new CmisObjectNotFoundException("Object with ID " + objectId + " does not exist");
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        throw new CmisObjectNotFoundException("Object with ID " + objectId + " does not exist");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Acl applyAcl(String repositoryId, String objectId, Acl acl, AclPropagation aclPropagation) {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        try (Tx tx = app.tx();){
            GraphObject obj = app.get(objectId);
            if (obj != null) {
                if (!(obj instanceof AbstractNode)) throw new CmisInvalidArgumentException("Object with ID " + objectId + " is not access controllable");
                AbstractNode node = (AbstractNode)obj;
                node.revokeAll();
                for (Ace toAdd : acl.getAces()) {
                    this.applyAce((AccessControllable)node, toAdd, false);
                }
            }
            tx.success();
            CMISObjectWrapper cMISObjectWrapper = CMISObjectWrapper.wrap((GraphObject)obj, null, (Boolean)false);
            return cMISObjectWrapper;
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
            throw new CmisObjectNotFoundException("Object with ID " + objectId + " does not exist");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Acl applyAcl(String repositoryId, String objectId, Acl addAces, Acl removeAces, AclPropagation aclPropagation, ExtensionsData extension) {
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        try (Tx tx = app.tx();){
            GraphObject obj = app.get(objectId);
            if (obj != null) {
                if (!(obj instanceof AccessControllable)) throw new CmisInvalidArgumentException("Object with ID " + objectId + " is not access controllable");
                AccessControllable node = (AccessControllable)obj;
                for (Ace toRemove : removeAces.getAces()) {
                    this.applyAce(node, toRemove, true);
                }
                for (Ace toAdd : addAces.getAces()) {
                    this.applyAce(node, toAdd, false);
                }
            }
            tx.success();
            CMISObjectWrapper cMISObjectWrapper = CMISObjectWrapper.wrap((GraphObject)obj, null, (Boolean)false);
            return cMISObjectWrapper;
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
            throw new CmisObjectNotFoundException("Object with ID " + objectId + " does not exist");
        }
    }

    private void applyAce(AccessControllable node, Ace toAdd, boolean revoke) throws FrameworkException {
        String principalId = toAdd.getPrincipalId();
        List permissions = toAdd.getPermissions();
        Principal principal = CMISObjectWrapper.translateUsernameToPrincipal((String)principalId);
        if (principal != null) {
            for (String permissionString : permissions) {
                Permission permission = Permissions.valueOf((String)permissionString);
                if (permission != null) {
                    if (revoke) {
                        node.revoke(permission, principal);
                        continue;
                    }
                    node.grant(permission, principal);
                    continue;
                }
                throw new CmisInvalidArgumentException("Permission with ID " + permissionString + " does not exist");
            }
        } else {
            throw new CmisObjectNotFoundException("Principal with ID " + principalId + " does not exist");
        }
    }
}

