/*
 * Decompiled with CFR 0.152.
 */
package org.structr.files.cmis;

import java.math.BigInteger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderContainer;
import org.apache.chemistry.opencmis.commons.data.ObjectInFolderList;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.data.ObjectParentData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectInFolderContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ObjectParentDataImpl;
import org.apache.chemistry.opencmis.commons.spi.NavigationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.cmis.wrapper.CMISObjectWrapper;
import org.structr.common.GraphObjectComparator;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.files.cmis.AbstractStructrCmisService;
import org.structr.files.cmis.StructrCMISService;
import org.structr.files.cmis.repository.CMISRootFolder;
import org.structr.files.cmis.wrapper.CMISObjectInFolderWrapper;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.Folder;
import org.structr.web.entity.Image;

public class CMISNavigationService
extends AbstractStructrCmisService
implements NavigationService {
    private static final Logger logger = LoggerFactory.getLogger((String)CMISNavigationService.class.getName());

    public CMISNavigationService(StructrCMISService parentService, SecurityContext securityContext) {
        super(parentService, securityContext);
    }

    public ObjectInFolderList getChildren(String repositoryId, String folderId, String propertyFilter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        App app = StructrApp.getInstance();
        CMISObjectInFolderWrapper wrapper = new CMISObjectInFolderWrapper(propertyFilter, includeAllowableActions, maxItems, skipCount);
        try (Tx tx = app.tx();){
            wrapper.wrap(this.getChildrenQuery(app, folderId).getAsList());
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return wrapper;
    }

    public List<ObjectInFolderContainer> getDescendants(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        LinkedList<ObjectInFolderContainer> result = new LinkedList<ObjectInFolderContainer>();
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            int maxDepth = Integer.MAX_VALUE;
            if (depth != null && depth.intValue() >= 0) {
                maxDepth = depth.intValue();
            }
            for (AbstractFile child : this.getChildrenQuery(app, folderId).getAsList()) {
                this.recursivelyCollectDescendants(result, child, maxDepth, 1, includeAllowableActions);
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return result;
    }

    public List<ObjectInFolderContainer> getFolderTree(String repositoryId, String folderId, BigInteger depth, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePathSegment, ExtensionsData extension) {
        LinkedList<ObjectInFolderContainer> result = new LinkedList<ObjectInFolderContainer>();
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            int maxDepth = Integer.MAX_VALUE;
            if (depth != null && depth.intValue() >= 0) {
                maxDepth = depth.intValue();
            }
            if ("/".equals(folderId)) {
                for (Folder folder : app.nodeQuery(Folder.class).and((PropertyKey)Folder.parent, null).sort((PropertyKey)AbstractNode.name).getAsList()) {
                    this.recursivelyCollectFolderTree(result, folder, maxDepth, 1, includeAllowableActions);
                }
            } else {
                Folder folder = (Folder)app.get(Folder.class, folderId);
                if (folder != null) {
                    List children = (List)folder.getProperty((PropertyKey)Folder.folders);
                    Collections.sort(children, new GraphObjectComparator((PropertyKey)AbstractNode.name, false));
                    for (Folder child : children) {
                        this.recursivelyCollectFolderTree(result, child, maxDepth, 1, includeAllowableActions);
                    }
                } else {
                    throw new CmisObjectNotFoundException("Folder with ID " + folderId + " does not exist");
                }
            }
            tx.success();
        }
        catch (FrameworkException fex) {
            logger.warn("", (Throwable)fex);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ObjectParentData> getObjectParents(String repositoryId, String objectId, String propertyFilter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includeRelativePathSegment, ExtensionsData extension) {
        App app = StructrApp.getInstance();
        try (Tx tx = app.tx();){
            LinkedList<ObjectParentData> data = new LinkedList<ObjectParentData>();
            GraphObject graphObject = app.get(objectId);
            if (graphObject instanceof AbstractFile) {
                Folder parent = (Folder)((Object)((AbstractFile)graphObject).getProperty((PropertyKey)AbstractFile.parent));
                CMISRootFolder element = parent != null ? CMISObjectWrapper.wrap((GraphObject)parent, (String)propertyFilter, (Boolean)includeAllowableActions) : new CMISRootFolder(propertyFilter, includeAllowableActions);
                ObjectParentDataImpl impl = new ObjectParentDataImpl((ObjectData)element);
                impl.setRelativePathSegment((String)graphObject.getProperty((PropertyKey)AbstractNode.name));
                data.add((ObjectParentData)impl);
            }
            tx.success();
            LinkedList<ObjectParentData> linkedList = data;
            return linkedList;
        }
        catch (Throwable t) {
            logger.warn("", t);
            return null;
        }
    }

    public ObjectData getFolderParent(String repositoryId, String folderId, String propertyFilter, ExtensionsData extension) {
        App app = StructrApp.getInstance();
        CMISObjectWrapper result = null;
        try (Tx tx = app.tx();){
            Folder parent;
            GraphObject graphObject = app.get(folderId);
            if (graphObject != null && graphObject instanceof AbstractFile && (parent = (Folder)((Object)((AbstractFile)graphObject).getProperty((PropertyKey)AbstractFile.parent))) != null) {
                result = CMISObjectWrapper.wrap((GraphObject)parent, (String)propertyFilter, (Boolean)false);
            }
            tx.success();
        }
        catch (Throwable t) {
            logger.warn("", t);
        }
        if (result != null) {
            return result;
        }
        return null;
    }

    public ObjectList getCheckedOutDocs(String repositoryId, String folderId, String filter, String orderBy, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        throw new CmisNotSupportedException();
    }

    private void recursivelyCollectFolderTree(List<ObjectInFolderContainer> list, Folder child, int maxDepth, int depth, Boolean includeAllowableActions) throws FrameworkException {
        if (depth > maxDepth) {
            return;
        }
        CMISObjectInFolderWrapper wrapper = new CMISObjectInFolderWrapper(includeAllowableActions);
        ObjectInFolderContainerImpl impl = new ObjectInFolderContainerImpl();
        LinkedList<ObjectInFolderContainer> childContainerList = new LinkedList<ObjectInFolderContainer>();
        String pathSegment = child.getName();
        impl.setObject(wrapper.wrapObjectData(wrapper.wrapGraphObject((GraphObject)child), pathSegment));
        impl.setChildren(childContainerList);
        list.add((ObjectInFolderContainer)impl);
        List children = (List)child.getProperty((PropertyKey)Folder.folders);
        Collections.sort(children, new GraphObjectComparator((PropertyKey)AbstractNode.name, false));
        for (Folder folderChild : children) {
            this.recursivelyCollectFolderTree(childContainerList, folderChild, maxDepth, depth + 1, includeAllowableActions);
        }
    }

    private void recursivelyCollectDescendants(List<ObjectInFolderContainer> list, AbstractFile child, int maxDepth, int depth, Boolean includeAllowableActions) throws FrameworkException {
        if (depth > maxDepth) {
            return;
        }
        CMISObjectInFolderWrapper wrapper = new CMISObjectInFolderWrapper(includeAllowableActions);
        ObjectInFolderContainerImpl impl = new ObjectInFolderContainerImpl();
        LinkedList<ObjectInFolderContainer> childContainerList = new LinkedList<ObjectInFolderContainer>();
        String pathSegment = child.getName();
        impl.setObject(wrapper.wrapObjectData(wrapper.wrapGraphObject((GraphObject)child), pathSegment));
        impl.setChildren(childContainerList);
        list.add((ObjectInFolderContainer)impl);
        if (((String)child.getProperty((PropertyKey)AbstractNode.type)).equals("Folder")) {
            App app = StructrApp.getInstance();
            for (AbstractFile folderChild : app.nodeQuery(AbstractFile.class).sort((PropertyKey)AbstractNode.name).and(AbstractFile.parent, (Object)((Folder)child)).and(Image.isThumbnail, (Object)false).getAsList()) {
                this.recursivelyCollectDescendants(childContainerList, folderChild, maxDepth, depth + 1, includeAllowableActions);
            }
        }
    }

    public Query<AbstractFile> getChildrenQuery(App app, String folderId) throws FrameworkException {
        Query query = app.nodeQuery(AbstractFile.class).sort((PropertyKey)AbstractNode.name);
        if ("/".equals(folderId)) {
            query.and(AbstractFile.hasParent, (Object)false).and(Image.isThumbnail, (Object)false);
        } else {
            Folder folder = (Folder)app.get(Folder.class, folderId);
            if (folder != null) {
                query.and(AbstractFile.parent, (Object)folder).and(Image.isThumbnail, (Object)false);
            } else {
                throw new CmisObjectNotFoundException("Folder with ID " + folderId + " does not exist");
            }
        }
        return query;
    }
}

