/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.common;

import java.io.OutputStream;
import java.util.Map;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeFactory;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.RelationshipFactory;
import org.structr.core.graph.SyncCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.dynamic.File;
import org.structr.rest.resource.MaintenanceParameterResource;
import org.structr.web.common.FileHelper;

public class DumpDatabaseCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    public void execute(Map<String, Object> attributes) throws FrameworkException {
        try {
            NodeFactory nodeFactory = new NodeFactory(SecurityContext.getSuperUserInstance());
            RelationshipFactory relFactory = new RelationshipFactory(SecurityContext.getSuperUserInstance());
            App app = StructrApp.getInstance();
            String fileName = (String)attributes.get("name");
            if (fileName == null || fileName.isEmpty()) {
                throw new FrameworkException(400, "Please specify name.");
            }
            try (Tx tx = app.tx();){
                File file = FileHelper.createFile(this.securityContext, new byte[0], "application/zip", File.class, fileName);
                file.setProperties(this.securityContext, new PropertyMap((PropertyKey)File.visibleToAuthenticatedUsers, (Object)true));
                SyncCommand.exportToStream((OutputStream)file.getOutputStream(), (Iterable)nodeFactory.bulkInstantiate(app.getDatabaseService().getAllNodes()), (Iterable)relFactory.bulkInstantiate(app.getDatabaseService().getAllRelationships()), null, (boolean)false);
                tx.success();
            }
        }
        catch (Throwable t) {
            throw new FrameworkException(500, t.getMessage());
        }
    }

    public boolean requiresEnclosingTransaction() {
        return true;
    }

    public boolean requiresFlushingOfCaches() {
        return false;
    }

    static {
        MaintenanceParameterResource.registerMaintenanceCommand("dumpDatabase", DumpDatabaseCommand.class);
    }
}

