/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.datasource;

import java.util.Collections;
import java.util.LinkedList;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.entity.AbstractNode;
import org.structr.web.common.GraphDataSource;
import org.structr.web.common.RenderContext;
import org.structr.web.entity.dom.DOMNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathGraphDataSource
implements GraphDataSource<Iterable<GraphObject>> {
    private static final Logger logger = LoggerFactory.getLogger((String)XPathGraphDataSource.class.getName());

    @Override
    public Iterable<GraphObject> getData(RenderContext renderContext, AbstractNode referenceNode) throws FrameworkException {
        String xpathQuery = (String)referenceNode.getProperty(DOMNode.xpathQuery);
        if (StringUtils.isBlank((CharSequence)xpathQuery)) {
            return null;
        }
        Document document = ((DOMNode)referenceNode).getOwnerDocument();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        try {
            Object result = xpath.evaluate(xpathQuery, document, XPathConstants.NODESET);
            LinkedList<GraphObject> results = new LinkedList<GraphObject>();
            if (result instanceof NodeList) {
                NodeList nodes = (NodeList)result;
                int len = nodes.getLength();
                for (int i = 0; i < len; ++i) {
                    Node node = nodes.item(i);
                    if (!(node instanceof GraphObject)) continue;
                    results.add((GraphObject)node);
                }
            } else if (result instanceof GraphObject) {
                results.add((GraphObject)result);
            }
            return results;
        }
        catch (Throwable t) {
            logger.warn("Unable to execute xpath query: {}", (Object)t.getMessage());
            return Collections.EMPTY_LIST;
        }
    }
}

