/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.diff;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.property.PropertyKey;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.relationship.DOMChildren;

public abstract class InvertibleModificationOperation
implements Comparable<InvertibleModificationOperation> {
    protected Map<String, DOMNode> hashMappedExistingNodes = new LinkedHashMap<String, DOMNode>();

    public abstract void apply(App var1, Page var2, Page var3) throws FrameworkException;

    public abstract InvertibleModificationOperation revert();

    public abstract Integer getPosition();

    public InvertibleModificationOperation(Map<String, DOMNode> hashMappedExistingNodes) {
        this.hashMappedExistingNodes = hashMappedExistingNodes;
    }

    protected InsertPosition findInsertPosition(Page sourcePage, String parentHash, List<String> siblingHashes, DOMNode newNode) {
        String siblingHash;
        DOMNode newParent = this.hashMappedExistingNodes.get(parentHash);
        DOMNode newSibling = null;
        Iterator<String> iterator = siblingHashes.iterator();
        while (iterator.hasNext() && (newSibling = this.hashMappedExistingNodes.get(siblingHash = iterator.next())) == null) {
        }
        if (newParent == null) {
            // empty if block
        }
        return new InsertPosition(newParent, newSibling);
    }

    public static void collectNodes(DOMNode node, Map<String, DOMNode> indexMappedNodes, Map<String, DOMNode> hashMappedNodes, Map<DOMNode, Integer> depthMap) {
        InvertibleModificationOperation.collectNodes(node, indexMappedNodes, hashMappedNodes, depthMap, 0, new LinkedHashMap<Integer, Integer>());
    }

    public static void collectNodes(Page page, Map<String, DOMNode> indexMappedNodes, Map<String, DOMNode> hashMappedNodes, Map<DOMNode, Integer> depthMap) {
        InvertibleModificationOperation.collectNodes(page, indexMappedNodes, hashMappedNodes, depthMap, 0, new LinkedHashMap<Integer, Integer>());
    }

    private static void collectNodes(DOMNode node, Map<String, DOMNode> indexMappedNodes, Map<String, DOMNode> hashMappedNodes, Map<DOMNode, Integer> depthMap, int depth, Map<Integer, Integer> childIndexMap) {
        if (node == null) {
            return;
        }
        Integer pos = childIndexMap.get(depth);
        if (pos == null) {
            pos = 0;
        }
        int position = pos;
        childIndexMap.put(depth, ++position);
        String hash = "[" + depth + ":" + position + "]";
        indexMappedNodes.put(hash, node);
        String dataHash = (String)node.getProperty((PropertyKey)DOMNode.dataHashProperty);
        if (dataHash == null) {
            dataHash = node.getIdHash();
        }
        hashMappedNodes.put(dataHash, node);
        depthMap.put(node, depth);
        for (DOMChildren childRel : node.getChildRelationships()) {
            InvertibleModificationOperation.collectNodes((DOMNode)childRel.getTargetNode(), indexMappedNodes, hashMappedNodes, depthMap, depth + 1, childIndexMap);
        }
    }

    @Override
    public int compareTo(InvertibleModificationOperation op) {
        return this.getPosition().compareTo(op.getPosition());
    }

    protected static class InsertPosition {
        private DOMNode parent = null;
        private DOMNode sibling = null;

        public InsertPosition(DOMNode parent, DOMNode sibling) {
            this.parent = parent;
            this.sibling = sibling;
        }

        public DOMNode getParent() {
            return this.parent;
        }

        public DOMNode getSibling() {
            return this.sibling;
        }
    }
}

