/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.Export;
import org.structr.core.graph.ModificationEvent;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.property.EndNodes;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.relation.MinificationSource;

public abstract class AbstractMinifiedFile
extends org.structr.dynamic.File {
    private static final Logger logger = LoggerFactory.getLogger((String)AbstractMinifiedFile.class.getName());
    public static final Property<List<FileBase>> minificationSources = new EndNodes("minificationSources", MinificationSource.class);

    @Override
    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        boolean shouldMinify = false;
        String myUUID = this.getUuid();
        for (ModificationEvent modState : modificationQueue.getModificationEvents()) {
            if (!myUUID.equals(modState.getUuid())) continue;
            shouldMinify = shouldMinify || this.shouldModificationTriggerMinifcation(modState);
        }
        if (shouldMinify) {
            try {
                this.minify();
            }
            catch (IOException ex) {
                logger.warn("Could not automatically minify file", (Throwable)ex);
            }
        }
        return super.onModification(securityContext, errorBuffer, modificationQueue);
    }

    @Export
    public abstract void minify() throws FrameworkException, IOException;

    public abstract boolean shouldModificationTriggerMinifcation(ModificationEvent var1);

    public int getMaxPosition() {
        int max = -1;
        for (MinificationSource neighbor : this.getOutgoingRelationships(MinificationSource.class)) {
            max = Math.max(max, (Integer)neighbor.getProperty((PropertyKey)MinificationSource.position));
        }
        return max;
    }

    public String getConcatenatedSource() throws FrameworkException, IOException {
        StringBuilder concatenatedSource = new StringBuilder();
        int cnt = 0;
        for (MinificationSource rel : this.getSortedRelationships()) {
            FileBase src = (FileBase)rel.getTargetNode();
            concatenatedSource.append(FileUtils.readFileToString((File)src.getFileOnDisk()));
            if ((Integer)rel.getProperty((PropertyKey)MinificationSource.position) != cnt) {
                rel.setProperties(this.securityContext, new PropertyMap(MinificationSource.position, (Object)cnt));
            }
            ++cnt;
        }
        return concatenatedSource.toString();
    }

    public List<MinificationSource> getSortedRelationships() {
        ArrayList<MinificationSource> rels = new ArrayList<MinificationSource>();
        this.getOutgoingRelationships(MinificationSource.class).forEach(rels::add);
        Collections.sort(rels, (arg0, arg1) -> ((Integer)arg0.getProperty((PropertyKey)MinificationSource.position)).compareTo((Integer)arg1.getProperty((PropertyKey)MinificationSource.position)));
        return rels;
    }

    @Export
    public void moveMinificationSource(int from, int to) throws FrameworkException {
        for (MinificationSource rel : this.getOutgoingRelationships(MinificationSource.class)) {
            int currentPosition = (Integer)rel.getProperty((PropertyKey)MinificationSource.position);
            int change = 0;
            if (from < to) {
                change = -1;
            } else if (from > to) {
                change = 1;
            }
            if (currentPosition > from && currentPosition <= to) {
                rel.setProperties(this.securityContext, new PropertyMap(MinificationSource.position, (Object)(currentPosition + change)));
                continue;
            }
            if (currentPosition >= to && currentPosition < from) {
                rel.setProperties(this.securityContext, new PropertyMap(MinificationSource.position, (Object)(currentPosition + change)));
                continue;
            }
            if (currentPosition != from) continue;
            rel.setProperties(this.securityContext, new PropertyMap(MinificationSource.position, (Object)to));
        }
    }
}

