/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity;

import com.google.javascript.jscomp.BasicErrorManager;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CommandLineRunner;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.ErrorManager;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.View;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.ModificationEvent;
import org.structr.core.property.EnumProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StringProperty;
import org.structr.web.common.FileHelper;
import org.structr.web.entity.AbstractMinifiedFile;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.relation.MinificationSource;

public class MinifiedJavaScriptFile
extends AbstractMinifiedFile {
    private static final Logger logger = LoggerFactory.getLogger((String)MinifiedJavaScriptFile.class.getName());
    public static final Property<CompilationLevel> optimizationLevel = new EnumProperty("optimizationLevel", CompilationLevel.class, (Enum)CompilationLevel.WHITESPACE_ONLY);
    public static final Property<String> warnings = new StringProperty("warnings");
    public static final Property<String> errors = new StringProperty("errors");
    public static final View defaultView = new View(MinifiedJavaScriptFile.class, "public", new Property[]{minificationSources, optimizationLevel, warnings, errors});
    public static final View uiView = new View(MinifiedJavaScriptFile.class, "ui", new Property[]{minificationSources, optimizationLevel, warnings, errors});

    @Override
    public boolean shouldModificationTriggerMinifcation(ModificationEvent modState) {
        return modState.getModifiedProperties().containsKey(optimizationLevel);
    }

    @Override
    public void minify() throws FrameworkException, IOException {
        logger.info("Running minify: {}", (Object)this.getUuid());
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        CompilationLevel selectedLevel = (CompilationLevel)this.getProperty((PropertyKey)optimizationLevel);
        selectedLevel.setOptionsForCompilationLevel(options);
        compiler.setErrorManager((ErrorManager)new BasicErrorManager(){

            public void println(CheckLevel level, JSError error) {
            }

            protected void printSummary() {
                if (this.getTypedPercent() > 0.0) {
                    if (this.getErrorCount() + this.getWarningCount() == 0) {
                        logger.info(SimpleFormat.format((String)"%d error(s), %d warning(s), %.1f%% typed", (Object[])new Object[]{this.getErrorCount(), this.getWarningCount(), this.getTypedPercent()}));
                    } else {
                        logger.warn(SimpleFormat.format((String)"%d error(s), %d warning(s), %.1f%% typed", (Object[])new Object[]{this.getErrorCount(), this.getWarningCount(), this.getTypedPercent()}));
                    }
                } else if (this.getErrorCount() + this.getWarningCount() > 0) {
                    logger.warn(SimpleFormat.format((String)"%d error(s), %d warning(s)", (Object[])new Object[]{this.getErrorCount(), this.getWarningCount()}));
                }
            }
        });
        compiler.compile(CommandLineRunner.getBuiltinExterns((CompilerOptions)options), this.getSourceFileList(), options);
        FileHelper.setFileData(this, compiler.toSource().getBytes(), (String)this.getProperty((PropertyKey)contentType));
        PropertyMap changedProperties = new PropertyMap();
        changedProperties.put(warnings, (Object)StringUtils.join((Object[])compiler.getWarnings(), (String)System.lineSeparator()));
        changedProperties.put(errors, (Object)StringUtils.join((Object[])compiler.getErrors(), (String)System.lineSeparator()));
        this.setProperties(this.securityContext, changedProperties);
    }

    private ArrayList<SourceFile> getSourceFileList() throws FrameworkException, IOException {
        ArrayList<SourceFile> sourceList = new ArrayList<SourceFile>();
        int cnt = 0;
        for (MinificationSource rel : this.getSortedRelationships()) {
            FileBase src = (FileBase)rel.getTargetNode();
            sourceList.add(SourceFile.fromCode((String)((String)src.getProperty((PropertyKey)FileBase.name)), (String)FileUtils.readFileToString((File)src.getFileOnDisk())));
            if ((Integer)rel.getProperty((PropertyKey)MinificationSource.position) != cnt) {
                rel.setProperties(this.securityContext, new PropertyMap(MinificationSource.position, (Object)cnt));
            }
            ++cnt;
        }
        return sourceList;
    }
}

