/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity;

import java.util.List;
import org.structr.api.config.Settings;
import org.structr.common.KeyAndClass;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractUser;
import org.structr.core.entity.Favoritable;
import org.structr.core.entity.Group;
import org.structr.core.entity.relationship.Groups;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.notion.Notion;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.ConstantBooleanProperty;
import org.structr.core.property.EndNode;
import org.structr.core.property.EndNodes;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StartNode;
import org.structr.core.property.StartNodes;
import org.structr.core.property.StringProperty;
import org.structr.schema.SchemaService;
import org.structr.web.entity.AbstractFile;
import org.structr.web.entity.Folder;
import org.structr.web.entity.Image;
import org.structr.web.entity.relation.UserFavoriteFavoritable;
import org.structr.web.entity.relation.UserHomeDir;
import org.structr.web.entity.relation.UserImage;
import org.structr.web.entity.relation.UserWorkDir;
import org.structr.web.property.ImageDataProperty;
import org.structr.web.property.UiNotion;

public class User
extends AbstractUser {
    public static final Property<String> confirmationKey = new StringProperty("confirmationKey").indexed();
    public static final Property<Boolean> backendUser = new BooleanProperty("backendUser").indexed();
    public static final Property<Boolean> frontendUser = new BooleanProperty("frontendUser").indexed();
    public static final Property<Image> img = new StartNode("img", UserImage.class);
    public static final ImageDataProperty imageData = new ImageDataProperty("imageData", new KeyAndClass(img, Image.class));
    public static final Property<Folder> homeDirectory = new EndNode("homeDirectory", UserHomeDir.class);
    public static final Property<Folder> workingDirectory = new EndNode("workingDirectory", UserWorkDir.class);
    public static final Property<List<Group>> groups = new StartNodes("groups", Groups.class, (Notion)new UiNotion());
    public static final Property<Boolean> isUser = new ConstantBooleanProperty("isUser", true);
    public static final Property<String> twitterName = new StringProperty("twitterName").cmis().indexed();
    public static final Property<String> localStorage = new StringProperty("localStorage");
    public static final Property<List<Favoritable>> favorites = new EndNodes("favorites", UserFavoriteFavoritable.class);
    public static final View uiView = new View(User.class, "ui", new Property[]{type, name, eMail, isAdmin, password, publicKey, blocked, sessionIds, confirmationKey, backendUser, frontendUser, groups, img, homeDirectory, workingDirectory, isUser, locale, favorites, proxyUrl, proxyUsername, proxyPassword});
    public static final View publicView = new View(User.class, "public", new Property[]{type, name, isUser});

    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (super.onCreation(securityContext, errorBuffer)) {
            this.checkAndCreateHomeDirectory(securityContext);
            return true;
        }
        return false;
    }

    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (super.onModification(securityContext, errorBuffer, modificationQueue)) {
            this.checkAndCreateHomeDirectory(securityContext);
            return true;
        }
        return false;
    }

    public boolean onDeletion(SecurityContext securityContext, ErrorBuffer errorBuffer, PropertyMap properties) throws FrameworkException {
        if (super.onDeletion(securityContext, errorBuffer, properties)) {
            this.checkAndRemoveHomeDirectory(securityContext);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndCreateHomeDirectory(SecurityContext securityContext) throws FrameworkException {
        if (((Boolean)Settings.FilesystemEnabled.getValue()).booleanValue()) {
            SecurityContext storedContext = this.securityContext;
            try {
                this.securityContext = SecurityContext.getSuperUserInstance();
                Folder homeDir = (Folder)((Object)this.getProperty((PropertyKey)homeDirectory));
                if (homeDir == null) {
                    App app = StructrApp.getInstance();
                    Folder homeFolder = (Folder)app.nodeQuery(Folder.class).and((PropertyKey)Folder.name, (Object)"home").and((PropertyKey)Folder.parent, null).getFirst();
                    if (homeFolder == null) {
                        homeFolder = (Folder)app.create(Folder.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)Folder.name, (Object)"home"), new NodeAttribute((PropertyKey)Folder.owner, null), new NodeAttribute((PropertyKey)Folder.visibleToAuthenticatedUsers, (Object)true)});
                    }
                    app.create(Folder.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)Folder.name, (Object)this.getUuid()), new NodeAttribute((PropertyKey)Folder.owner, (Object)this), new NodeAttribute(AbstractFile.parent, (Object)homeFolder), new NodeAttribute((PropertyKey)Folder.visibleToAuthenticatedUsers, (Object)true), new NodeAttribute(Folder.homeFolderOfUser, (Object)this)});
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                this.securityContext = storedContext;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndRemoveHomeDirectory(SecurityContext securityContext) throws FrameworkException {
        if (((Boolean)Settings.FilesystemEnabled.getValue()).booleanValue()) {
            SecurityContext storedContext = this.securityContext;
            try {
                this.securityContext = SecurityContext.getSuperUserInstance();
                Folder homeDir = (Folder)((Object)this.getProperty((PropertyKey)homeDirectory));
                if (homeDir != null) {
                    StructrApp.getInstance().delete((NodeInterface)homeDir);
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                this.securityContext = storedContext;
            }
        }
    }

    static {
        SchemaService.registerBuiltinTypeOverride((String)"User", (String)User.class.getName());
    }
}

