/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.Predicate;
import org.structr.api.util.Iterables;
import org.structr.common.AccessControllable;
import org.structr.common.CaseHelper;
import org.structr.common.Filter;
import org.structr.common.Permission;
import org.structr.common.SecurityContext;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.ErrorToken;
import org.structr.common.error.FrameworkException;
import org.structr.common.error.SemanticErrorToken;
import org.structr.common.error.UnlicensedException;
import org.structr.core.GraphObject;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.LinkedListNode;
import org.structr.core.entity.LinkedTreeNode;
import org.structr.core.entity.Principal;
import org.structr.core.entity.Security;
import org.structr.core.graph.ModificationQueue;
import org.structr.core.graph.NodeInterface;
import org.structr.core.notion.Notion;
import org.structr.core.notion.PropertyNotion;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.CollectionIdProperty;
import org.structr.core.property.ConstantBooleanProperty;
import org.structr.core.property.EndNode;
import org.structr.core.property.EndNodes;
import org.structr.core.property.EntityIdProperty;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.IntProperty;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.core.property.StartNode;
import org.structr.core.property.StringProperty;
import org.structr.core.script.Scripting;
import org.structr.schema.action.ActionContext;
import org.structr.web.common.AsyncBuffer;
import org.structr.web.common.GraphDataSource;
import org.structr.web.common.RenderContext;
import org.structr.web.common.StringRenderBuffer;
import org.structr.web.datasource.CypherGraphDataSource;
import org.structr.web.datasource.FunctionDataSource;
import org.structr.web.datasource.IdRequestParameterGraphDataSource;
import org.structr.web.datasource.NodeGraphDataSource;
import org.structr.web.datasource.RestDataSource;
import org.structr.web.datasource.XPathGraphDataSource;
import org.structr.web.entity.LinkSource;
import org.structr.web.entity.Linkable;
import org.structr.web.entity.Renderable;
import org.structr.web.entity.dom.Content;
import org.structr.web.entity.dom.DOMAdoptable;
import org.structr.web.entity.dom.DOMElement;
import org.structr.web.entity.dom.DOMImportable;
import org.structr.web.entity.dom.DOMNodeList;
import org.structr.web.entity.dom.DocumentFragment;
import org.structr.web.entity.dom.Page;
import org.structr.web.entity.dom.ShadowDocument;
import org.structr.web.entity.dom.Template;
import org.structr.web.entity.dom.relationship.DOMChildren;
import org.structr.web.entity.dom.relationship.DOMSiblings;
import org.structr.web.entity.relation.PageLink;
import org.structr.web.entity.relation.RenderNode;
import org.structr.web.entity.relation.Sync;
import org.structr.websocket.command.CreateComponentCommand;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

public abstract class DOMNode
extends LinkedTreeNode<DOMChildren, DOMSiblings, DOMNode>
implements Node,
Renderable,
DOMAdoptable,
DOMImportable {
    private static final Logger logger = LoggerFactory.getLogger((String)DOMNode.class.getName());
    protected static final String NO_MODIFICATION_ALLOWED_MESSAGE = "Permission denied.";
    protected static final String INVALID_ACCESS_ERR_MESSAGE = "Permission denied.";
    protected static final String INDEX_SIZE_ERR_MESSAGE = "Index out of range.";
    protected static final String CANNOT_SPLIT_TEXT_WITHOUT_PARENT = "Cannot split text element without parent and/or owner document.";
    protected static final String WRONG_DOCUMENT_ERR_MESSAGE = "Node does not belong to this document.";
    protected static final String HIERARCHY_REQUEST_ERR_MESSAGE_SAME_NODE = "A node cannot accept itself as a child.";
    protected static final String HIERARCHY_REQUEST_ERR_MESSAGE_ANCESTOR = "A node cannot accept its own ancestor as child.";
    protected static final String HIERARCHY_REQUEST_ERR_MESSAGE_DOCUMENT = "A document may only have one html element.";
    protected static final String HIERARCHY_REQUEST_ERR_MESSAGE_ELEMENT = "A document may only accept an html element as its document element.";
    protected static final String NOT_SUPPORTED_ERR_MESSAGE = "Node type not supported.";
    protected static final String NOT_FOUND_ERR_MESSAGE = "Node is not a child.";
    protected static final String NOT_SUPPORTED_ERR_MESSAGE_IMPORT_DOC = "Document nodes cannot be imported into another document.";
    protected static final String NOT_SUPPORTED_ERR_MESSAGE_ADOPT_DOC = "Document nodes cannot be adopted by another document.";
    protected static final String NOT_SUPPORTED_ERR_MESSAGE_RENAME = "Renaming of nodes is not supported by this implementation.";
    private static final List<GraphDataSource<Iterable<GraphObject>>> listSources = new LinkedList<GraphDataSource<Iterable<GraphObject>>>();
    private Page cachedOwnerDocument;
    public static final Property<String> dataKey;
    public static final Property<String> cypherQuery;
    public static final Property<String> xpathQuery;
    public static final Property<String> restQuery;
    public static final Property<String> functionQuery;
    public static final Property<Boolean> renderDetails;
    public static final Property<List<DOMNode>> syncedNodes;
    public static final Property<DOMNode> sharedComponent;
    public static final Property<String> sharedComponentConfiguration;
    public static final Property<Boolean> hideOnIndex;
    public static final Property<Boolean> hideOnDetail;
    public static final Property<String> showForLocales;
    public static final Property<String> hideForLocales;
    public static final Property<String> showConditions;
    public static final Property<String> hideConditions;
    public static final Property<DOMNode> parent;
    public static final Property<String> parentId;
    public static final Property<List<DOMNode>> children;
    public static final Property<List<String>> childrenIds;
    public static final Property<DOMNode> previousSibling;
    public static final Property<DOMNode> nextSibling;
    public static final Property<String> nextSiblingId;
    public static final Property<Page> ownerDocument;
    public static final Property<String> pageId;
    public static final Property<Boolean> isDOMNode;
    public static final Property<String> dataStructrIdProperty;
    public static final Property<String> dataHashProperty;
    public static final Property<Integer> domSortPosition;
    public static final Property[] rawProps;
    private Set<PropertyKey> dataProperties = null;
    private Map<String, Integer> cachedMostUsedTagNames = null;
    private String cachedPagePath = null;

    public abstract boolean isSynced();

    public abstract boolean contentEquals(DOMNode var1);

    public abstract String getContextName();

    public abstract void updateFromNode(DOMNode var1) throws FrameworkException;

    public String getIdHash() {
        return this.getUuid();
    }

    public String getIdHashOrProperty() {
        String idHash = (String)this.getProperty((PropertyKey)dataHashProperty);
        if (idHash == null) {
            idHash = this.getIdHash();
        }
        return idHash;
    }

    public Class<DOMChildren> getChildLinkType() {
        return DOMChildren.class;
    }

    public Class<DOMSiblings> getSiblingLinkType() {
        return DOMSiblings.class;
    }

    public boolean isSharedComponent() {
        Document _ownerDocument = this.getOwnerDocumentAsSuperUser();
        if (_ownerDocument != null) {
            try {
                return _ownerDocument.equals(CreateComponentCommand.getOrCreateHiddenDocument());
            }
            catch (FrameworkException fex) {
                logger.warn("Unable fetch ShadowDocument node: {}", (Object)fex.getMessage());
            }
        }
        return false;
    }

    public List<DOMChildren> getChildRelationships() {
        return this.treeGetChildRelationships();
    }

    public String getPositionPath() {
        String path = "";
        DOMNode currentNode = this;
        while (currentNode.getParentNode() != null) {
            DOMNode parentNode = (DOMNode)currentNode.getParentNode();
            path = "/" + parentNode.treeGetChildPosition(currentNode) + path;
            currentNode = parentNode;
        }
        return path;
    }

    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (super.onCreation(securityContext, errorBuffer)) {
            return this.checkName(errorBuffer);
        }
        return false;
    }

    public boolean onModification(SecurityContext securityContext, ErrorBuffer errorBuffer, ModificationQueue modificationQueue) throws FrameworkException {
        if (super.onModification(securityContext, errorBuffer, modificationQueue)) {
            if (this.dataProperties != null) {
                this.dataProperties.clear();
            }
            try {
                this.increasePageVersion();
            }
            catch (FrameworkException ex) {
                logger.warn("Updating page version failed", (Throwable)ex);
            }
            return this.checkName(errorBuffer);
        }
        return false;
    }

    @Override
    public void render(RenderContext renderContext, int depth) throws FrameworkException {
        boolean detailMode;
        if (!this.securityContext.isVisible((AccessControllable)this)) {
            return;
        }
        GraphObject details = renderContext.getDetailsDataObject();
        boolean bl = detailMode = details != null;
        if (detailMode && ((Boolean)this.getProperty((PropertyKey)hideOnDetail)).booleanValue()) {
            return;
        }
        if (!detailMode && ((Boolean)this.getProperty((PropertyKey)hideOnIndex)).booleanValue()) {
            return;
        }
        RenderContext.EditMode editMode = renderContext.getEditMode(this.securityContext.getUser(false));
        if (RenderContext.EditMode.RAW.equals((Object)editMode) || RenderContext.EditMode.WIDGET.equals((Object)editMode) || RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode)) {
            this.renderContent(renderContext, depth);
        } else {
            String subKey = (String)this.getProperty((PropertyKey)dataKey);
            if (StringUtils.isNotBlank((CharSequence)subKey)) {
                this.setDataRoot(renderContext, (AbstractNode)this, subKey);
                GraphObject currentDataNode = renderContext.getDataObject();
                Iterable<GraphObject> listData = this.checkListSources(this.securityContext, renderContext);
                if (((Boolean)this.getProperty((PropertyKey)renderDetails)).booleanValue() && detailMode) {
                    renderContext.setDataObject(details);
                    renderContext.putDataObject(subKey, details);
                    this.renderContent(renderContext, depth);
                } else if (Iterables.isEmpty(listData) && currentDataNode != null) {
                    Object elements = currentDataNode.getProperty((PropertyKey)new GenericProperty(subKey));
                    renderContext.setRelatedProperty((PropertyKey)new GenericProperty(subKey));
                    renderContext.setSourceDataObject(currentDataNode);
                    if (elements != null) {
                        if (elements instanceof Iterable) {
                            for (Object o : (Iterable)elements) {
                                if (!(o instanceof GraphObject)) continue;
                                GraphObject graphObject = (GraphObject)o;
                                renderContext.putDataObject(subKey, graphObject);
                                this.renderContent(renderContext, depth);
                            }
                        }
                    } else {
                        Object value;
                        PropertyKey propertyKey = StructrApp.getConfiguration().getPropertyKeyForJSONName(currentDataNode.getClass(), subKey, false);
                        renderContext.setRelatedProperty(propertyKey);
                        if (propertyKey != null && (value = currentDataNode.getProperty(propertyKey)) != null && value instanceof Iterable) {
                            for (Object o : (Iterable)value) {
                                if (!(o instanceof GraphObject)) continue;
                                renderContext.putDataObject(subKey, (GraphObject)o);
                                this.renderContent(renderContext, depth);
                            }
                        }
                    }
                    renderContext.setDataObject(currentDataNode);
                    renderContext.setRelatedProperty(null);
                } else {
                    renderContext.setListSource(listData);
                    this.renderNodeList(this.securityContext, renderContext, depth, subKey);
                }
            } else {
                this.renderContent(renderContext, depth);
            }
        }
    }

    public String getContent(RenderContext.EditMode editMode) throws FrameworkException {
        RenderContext ctx = new RenderContext(this.securityContext, null, null, editMode);
        StringRenderBuffer buffer = new StringRenderBuffer();
        ctx.setBuffer(buffer);
        this.render(ctx, 0);
        return buffer.getBuffer().toString();
    }

    public Template getClosestTemplate(Page page) {
        for (DOMNode node = this; node != null; node = (DOMNode)node.getParentNode()) {
            if (!(node instanceof Template)) continue;
            Template template = (Template)node;
            Document doc = template.getOwnerDocument();
            if (doc == null) {
                doc = node.getClosestPage();
            }
            if (doc != null && (page == null || doc.equals(page))) {
                return template;
            }
            List _syncedNodes = (List)template.getProperty((PropertyKey)syncedNodes);
            for (DOMNode syncedNode : _syncedNodes) {
                doc = syncedNode.getOwnerDocument();
                if (doc == null || page != null && !doc.equals(page)) continue;
                return (Template)syncedNode;
            }
        }
        return null;
    }

    public Page getClosestPage() {
        for (DOMNode node = this; node != null; node = (DOMNode)node.getParentNode()) {
            if (!(node instanceof Page)) continue;
            return (Page)node;
        }
        return null;
    }

    public boolean inTrash() {
        return this.getProperty((PropertyKey)parent) == null && this.getOwnerDocumentAsSuperUser() == null;
    }

    private List<Node> getAncestors() {
        ArrayList<Node> ancestors = new ArrayList<Node>();
        for (Node _parent = this.getParentNode(); _parent != null; _parent = _parent.getParentNode()) {
            ancestors.add(_parent);
        }
        return ancestors;
    }

    protected void handleNewChild(Node newChild) {
        Page page = (Page)this.getOwnerDocument();
        for (DOMNode child : this.getAllChildNodes()) {
            try {
                child.setProperties(child.getSecurityContext(), new PropertyMap(ownerDocument, (Object)page));
            }
            catch (FrameworkException ex) {
                logger.warn("", (Throwable)ex);
            }
        }
    }

    protected boolean renderDeploymentExportComments(AsyncBuffer out, boolean isContentNode) {
        LinkedHashSet<String> instructions = new LinkedHashSet<String>();
        this.getVisibilityInstructions(instructions);
        this.getLinkableInstructions(instructions);
        this.getSecurityInstructions(instructions);
        if (isContentNode) {
            this.getContentInstructions(instructions);
        }
        if (!instructions.isEmpty()) {
            out.append("<!-- ");
            Iterator it = instructions.iterator();
            while (it.hasNext()) {
                String instruction = (String)it.next();
                out.append(instruction);
                if (!it.hasNext()) continue;
                out.append(", ");
            }
            out.append(" -->");
            return true;
        }
        return false;
    }

    protected void renderSharedComponentConfiguration(AsyncBuffer out, RenderContext.EditMode editMode) {
        String configuration;
        if (RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode) && StringUtils.isNotBlank((CharSequence)(configuration = (String)this.getProperty((PropertyKey)sharedComponentConfiguration)))) {
            out.append(" data-structr-meta-shared-component-configuration=\"");
            out.append(DOMNode.escapeForHtmlAttributes(configuration));
            out.append("\"");
        }
    }

    private void getContentInstructions(Set<String> instructions) {
        String _hideConditions;
        String _showConditions;
        String _contentType = (String)this.getProperty((PropertyKey)Content.contentType);
        if (_contentType != null) {
            instructions.add("@structr:content(" + DOMNode.escapeForHtmlAttributes(_contentType) + ")");
        }
        if (StringUtils.isNotEmpty((CharSequence)(_showConditions = (String)this.getProperty((PropertyKey)showConditions)))) {
            instructions.add("@structr:show(" + DOMNode.escapeForHtmlAttributes(_showConditions) + ")");
        }
        if (StringUtils.isNotEmpty((CharSequence)(_hideConditions = (String)this.getProperty((PropertyKey)hideConditions)))) {
            instructions.add("@structr:hide(" + DOMNode.escapeForHtmlAttributes(_hideConditions) + ")");
        }
    }

    private void getLinkableInstructions(Set<String> instructions) {
        LinkSource linkSourceElement;
        Linkable linkable;
        if (this instanceof LinkSource && (linkable = (Linkable)(linkSourceElement = (LinkSource)this).getProperty((PropertyKey)LinkSource.linkable)) != null) {
            String path = linkable.getPath();
            if (path != null) {
                instructions.add("@structr:link(" + path + ")");
            } else {
                logger.warn("Cannot export linkable relationship, no path.");
            }
        }
    }

    private void getVisibilityInstructions(Set<String> instructions) {
        boolean elementPublicOnly;
        Page _ownerDocument = (Page)this.getOwnerDocument();
        if (_ownerDocument == null) {
            logger.warn("DOMNode {} has no owner document!", (Object)this.getUuid());
        }
        boolean pagePublic = _ownerDocument != null ? _ownerDocument.isVisibleToPublicUsers() : false;
        boolean pageProtected = _ownerDocument != null ? _ownerDocument.isVisibleToAuthenticatedUsers() : false;
        boolean pagePrivate = !pagePublic && !pageProtected;
        boolean pagePublicOnly = pagePublic && !pageProtected;
        boolean elementPublic = this.isVisibleToPublicUsers();
        boolean elementProtected = this.isVisibleToAuthenticatedUsers();
        boolean elementPrivate = !elementPublic && !elementProtected;
        boolean bl = elementPublicOnly = elementPublic && !elementProtected;
        if (pagePrivate && !elementPrivate) {
            if (elementPublicOnly) {
                instructions.add("@structr:public-only");
                return;
            }
            if (elementPublic && elementProtected) {
                instructions.add("@structr:public");
                return;
            }
            if (elementProtected) {
                instructions.add("@structr:protected");
                return;
            }
        }
        if (pageProtected && !elementProtected) {
            if (elementPublicOnly) {
                instructions.add("@structr:public-only");
                return;
            }
            if (elementPublic && elementProtected) {
                instructions.add("@structr:public");
                return;
            }
            if (elementPrivate) {
                instructions.add("@structr:private");
                return;
            }
        }
        if (pagePublic && !elementPublic) {
            if (elementPublicOnly) {
                instructions.add("@structr:public-only");
                return;
            }
            if (elementProtected) {
                instructions.add("@structr:protected");
                return;
            }
            if (elementPrivate) {
                instructions.add("@structr:private");
                return;
            }
        }
        if (pagePublicOnly && !elementPublicOnly) {
            if (elementPublic && elementProtected) {
                instructions.add("@structr:public");
                return;
            }
            if (elementProtected) {
                instructions.add("@structr:protected");
                return;
            }
            if (elementPrivate) {
                instructions.add("@structr:private");
                return;
            }
            return;
        }
    }

    private void getSecurityInstructions(Set<String> instructions) {
        Principal _owner = this.getOwnerNode();
        if (_owner != null) {
            instructions.add("@structr:owner(" + (String)_owner.getProperty((PropertyKey)AbstractNode.name) + ")");
        }
        for (Security security : this.getSecurityRelationships()) {
            if (security == null) continue;
            Principal grantee = (Principal)security.getSourceNode();
            Set perms = security.getPermissions();
            StringBuilder shortPerms = new StringBuilder();
            for (String perm : perms) {
                shortPerms.append(perm.substring(0, 1));
            }
            instructions.add("@structr:grant(" + (String)grantee.getProperty((PropertyKey)AbstractNode.name) + "," + shortPerms.toString() + ")");
        }
    }

    protected void renderCustomAttributes(AsyncBuffer out, SecurityContext securityContext, RenderContext renderContext) throws FrameworkException {
        this.dbNode = this.getNode();
        RenderContext.EditMode editMode = renderContext.getEditMode(securityContext.getUser(false));
        for (PropertyKey key : this.getDataPropertyKeys()) {
            String value = "";
            if (RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode)) {
                Object obj = this.getProperty(key);
                if (obj != null) {
                    value = obj.toString();
                }
            } else {
                value = this.getPropertyWithVariableReplacement(renderContext, key);
                if (value != null) {
                    value = value.trim();
                }
            }
            if (!RenderContext.EditMode.RAW.equals((Object)editMode) && !RenderContext.EditMode.WIDGET.equals((Object)editMode)) {
                value = DOMNode.escapeForHtmlAttributes(value);
            }
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            out.append(" ").append(key.dbName()).append("=\"").append(value).append("\"");
        }
        if (RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode) || RenderContext.EditMode.RAW.equals((Object)editMode) || RenderContext.EditMode.WIDGET.equals((Object)editMode)) {
            String name;
            if (RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode) && (name = (String)this.getProperty((PropertyKey)AbstractNode.name)) != null) {
                out.append(" data-structr-meta-name=\"").append(DOMNode.escapeForHtmlAttributes(name)).append("\"");
            }
            for (Property p : rawProps) {
                String htmlName = "data-structr-meta-" + CaseHelper.toUnderscore((String)p.jsonName(), (boolean)false).replaceAll("_", "-");
                Object value = this.getProperty((PropertyKey)p);
                if (value == null) continue;
                boolean isBoolean = p instanceof BooleanProperty;
                String stringValue = value.toString();
                if ((!isBoolean || !"true".equals(stringValue)) && (isBoolean || !StringUtils.isNotBlank((CharSequence)stringValue))) continue;
                out.append(" ").append(htmlName).append("=\"").append(DOMNode.escapeForHtmlAttributes(stringValue)).append("\"");
            }
        }
    }

    protected Set<PropertyKey> getDataPropertyKeys() {
        if (this.dataProperties == null) {
            this.dataProperties = new TreeSet<PropertyKey>();
            Iterable props = this.dbNode.getPropertyKeys();
            for (String key : props) {
                if (!key.startsWith("data-")) continue;
                this.dataProperties.add(StructrApp.getConfiguration().getPropertyKeyForJSONName(this.getClass(), key));
            }
        }
        return this.dataProperties;
    }

    protected void setDataRoot(RenderContext renderContext, AbstractNode node, String dataKey) {
        block0: {
            Iterator iterator = node.getOutgoingRelationships(RenderNode.class).iterator();
            if (!iterator.hasNext()) break block0;
            RenderNode rel = (RenderNode)((Object)iterator.next());
            NodeInterface dataRoot = rel.getTargetNode();
            renderContext.putDataObject(dataKey, (GraphObject)dataRoot);
        }
    }

    public void renderNodeList(SecurityContext securityContext, RenderContext renderContext, int depth, String dataKey) throws FrameworkException {
        Iterable<GraphObject> listSource = renderContext.getListSource();
        if (listSource != null) {
            for (GraphObject dataObject : listSource) {
                renderContext.putDataObject(dataKey, dataObject);
                this.renderContent(renderContext, depth + 1);
            }
            renderContext.clearDataObject(dataKey);
        }
    }

    protected Iterable<GraphObject> checkListSources(SecurityContext securityContext, RenderContext renderContext) {
        for (GraphDataSource<Iterable<GraphObject>> source : listSources) {
            try {
                Iterable<GraphObject> graphData = source.getData(renderContext, (AbstractNode)this);
                if (graphData == null || Iterables.isEmpty(graphData)) continue;
                return graphData;
            }
            catch (FrameworkException fex) {
                logger.warn("", (Throwable)fex);
                logger.warn("Could not retrieve data from graph data source {}: {}", new Object[]{source, fex});
            }
        }
        return Collections.EMPTY_LIST;
    }

    protected void increasePageVersion() throws FrameworkException {
        Page page = null;
        if (this instanceof Page) {
            page = (Page)this;
        } else if (this.getProperty((PropertyKey)parent) == null) {
            return;
        }
        if (page == null) {
            List<Node> ancestors = this.getAncestors();
            if (!ancestors.isEmpty()) {
                DOMNode rootNode = (DOMNode)ancestors.get(ancestors.size() - 1);
                if (rootNode instanceof Page) {
                    page = (Page)rootNode;
                } else {
                    rootNode.increasePageVersion();
                }
            } else {
                List _syncedNodes = (List)this.getProperty((PropertyKey)syncedNodes);
                for (DOMNode syncedNode : _syncedNodes) {
                    syncedNode.increasePageVersion();
                }
            }
        }
        if (page != null) {
            page.increaseVersion();
        }
    }

    protected boolean avoidWhitespace() {
        return false;
    }

    protected void checkIsChild(Node otherNode) throws DOMException {
        if (otherNode instanceof DOMNode) {
            Node _parent = otherNode.getParentNode();
            if (!this.isSameNode(_parent)) {
                throw new DOMException(8, NOT_FOUND_ERR_MESSAGE);
            }
            return;
        }
        throw new DOMException(9, NOT_SUPPORTED_ERR_MESSAGE);
    }

    protected void checkHierarchy(Node otherNode) throws DOMException {
        if (otherNode instanceof DOMNode) {
            if (this.isSameNode(otherNode)) {
                throw new DOMException(3, HIERARCHY_REQUEST_ERR_MESSAGE_SAME_NODE);
            }
            for (Node _parent = this.getParentNode(); _parent != null; _parent = _parent.getParentNode()) {
                if (!_parent.isSameNode(otherNode)) continue;
                throw new DOMException(3, HIERARCHY_REQUEST_ERR_MESSAGE_ANCESTOR);
            }
            return;
        }
        throw new DOMException(9, NOT_SUPPORTED_ERR_MESSAGE);
    }

    protected void checkSameDocument(Node otherNode) throws DOMException {
        Document doc = this.getOwnerDocument();
        if (doc != null) {
            Document otherDoc = otherNode.getOwnerDocument();
            if (otherDoc != null && !doc.equals(otherDoc) && !(doc instanceof ShadowDocument)) {
                logger.warn("{} node with UUID {} has owner document {} with UUID {} whereas this node has owner document {} with UUID {}", new Object[]{otherNode.getClass().getSimpleName(), ((NodeInterface)otherNode).getUuid(), otherDoc.getClass().getSimpleName(), ((NodeInterface)otherDoc).getUuid(), doc.getClass().getSimpleName(), ((NodeInterface)doc).getUuid()});
                throw new DOMException(4, WRONG_DOCUMENT_ERR_MESSAGE);
            }
            if (otherDoc == null) {
                ((DOMNode)otherNode).doAdopt((Page)doc);
            }
        }
    }

    protected void checkWriteAccess() throws DOMException {
        if (!this.isGranted(Permission.write, this.securityContext)) {
            logger.warn("User {} has no write access to {} node with UUID {}", new Object[]{this.securityContext.getUser(false), this.getClass().getSimpleName(), this.getUuid()});
            throw new DOMException(7, "Permission denied.");
        }
    }

    protected void checkReadAccess() throws DOMException {
        if (this.securityContext.isVisible((AccessControllable)this) || this.isGranted(Permission.read, this.securityContext)) {
            return;
        }
        logger.warn("User {} has no read access to {} node with UUID {}", new Object[]{this.securityContext.getUser(false), this.getClass().getSimpleName(), this.getUuid()});
        throw new DOMException(15, "Permission denied.");
    }

    public static String indent(int depth, RenderContext renderContext) {
        if (!renderContext.shouldIndentHtml()) {
            return "";
        }
        StringBuilder indent = new StringBuilder("\n");
        for (int d = 0; d < depth; ++d) {
            indent.append("\t");
        }
        return indent.toString();
    }

    protected boolean displayForConditions(RenderContext renderContext) {
        RenderContext.EditMode editMode = renderContext.getEditMode(this.securityContext.getUser(false));
        if (RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode) || RenderContext.EditMode.RAW.equals((Object)editMode) || RenderContext.EditMode.WIDGET.equals((Object)editMode)) {
            return true;
        }
        String _showConditions = (String)this.getProperty((PropertyKey)showConditions);
        String _hideConditions = (String)this.getProperty((PropertyKey)hideConditions);
        if (StringUtils.isBlank((CharSequence)_hideConditions) && StringUtils.isBlank((CharSequence)_showConditions)) {
            return true;
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)_hideConditions) && Boolean.TRUE.equals(Scripting.evaluate((ActionContext)renderContext, (GraphObject)this, (String)"${".concat(_hideConditions).concat("}"), (String)"hide condition"))) {
                return false;
            }
        }
        catch (FrameworkException | UnlicensedException ex) {
            logger.error("Hide conditions " + _hideConditions + " could not be evaluated.", ex);
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)_showConditions) && Boolean.FALSE.equals(Scripting.evaluate((ActionContext)renderContext, (GraphObject)this, (String)"${".concat(_showConditions).concat("}"), (String)"show condition"))) {
                return false;
            }
        }
        catch (FrameworkException | UnlicensedException ex) {
            logger.error("Show conditions " + _showConditions + " could not be evaluated.", ex);
        }
        return true;
    }

    protected boolean displayForLocale(RenderContext renderContext) {
        RenderContext.EditMode editMode = renderContext.getEditMode(this.securityContext.getUser(false));
        if (RenderContext.EditMode.DEPLOYMENT.equals((Object)editMode) || RenderContext.EditMode.RAW.equals((Object)editMode) || RenderContext.EditMode.WIDGET.equals((Object)editMode)) {
            return true;
        }
        String localeString = renderContext.getLocale().toString();
        String show = (String)this.getProperty((PropertyKey)showForLocales);
        String hide = (String)this.getProperty((PropertyKey)hideForLocales);
        if (StringUtils.isBlank((CharSequence)hide) && StringUtils.isBlank((CharSequence)show)) {
            return true;
        }
        if (StringUtils.contains((CharSequence)hide, (CharSequence)localeString)) {
            return false;
        }
        return !StringUtils.isNotBlank((CharSequence)show) || StringUtils.contains((CharSequence)show, (CharSequence)localeString);
    }

    public static String escapeForHtml(String raw) {
        return StringUtils.replaceEach((String)raw, (String[])new String[]{"&", "<", ">"}, (String[])new String[]{"&amp;", "&lt;", "&gt;"});
    }

    public static String escapeForHtmlAttributes(String raw) {
        return StringUtils.replaceEach((String)raw, (String[])new String[]{"&", "<", ">", "\""}, (String[])new String[]{"&amp;", "&lt;", "&gt;", "&quot;"});
    }

    protected void collectNodesByPredicate(Node startNode, DOMNodeList results, Predicate<Node> predicate, int depth, boolean stopOnFirstHit) {
        NodeList _children;
        if (predicate instanceof Filter) {
            ((Filter)predicate).setSecurityContext(this.securityContext);
        }
        if (predicate.accept((Object)startNode)) {
            results.add(startNode);
            if (stopOnFirstHit) {
                return;
            }
        }
        if ((_children = startNode.getChildNodes()) != null) {
            int len = _children.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = _children.item(i);
                this.collectNodesByPredicate(child, results, predicate, depth + 1, stopOnFirstHit);
            }
        }
    }

    @Override
    public String getTextContent() throws DOMException {
        DOMNodeList results = new DOMNodeList();
        TextCollector textCollector = new TextCollector();
        this.collectNodesByPredicate(this, results, textCollector, 0, false);
        return textCollector.getText();
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
    }

    @Override
    public Node getParentNode() {
        return (Node)this.getProperty((PropertyKey)parent);
    }

    @Override
    public NodeList getChildNodes() {
        this.checkReadAccess();
        return new DOMNodeList(this.treeGetChildren());
    }

    @Override
    public Node getFirstChild() {
        this.checkReadAccess();
        return (Node)this.treeGetFirstChild();
    }

    @Override
    public Node getLastChild() {
        return (Node)this.treeGetLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        return (Node)this.listGetPrevious((LinkedListNode)this);
    }

    @Override
    public Node getNextSibling() {
        return (Node)this.listGetNext((LinkedListNode)this);
    }

    @Override
    public Document getOwnerDocument() {
        return (Document)this.getProperty((PropertyKey)ownerDocument);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (refChild == null) {
            return this.appendChild(newChild);
        }
        this.checkWriteAccess();
        this.checkSameDocument(newChild);
        this.checkSameDocument(refChild);
        this.checkHierarchy(newChild);
        this.checkHierarchy(refChild);
        if (newChild instanceof DocumentFragment) {
            DocumentFragment fragment = (DocumentFragment)newChild;
            Node currentChild = fragment.getFirstChild();
            while (currentChild != null) {
                Node savedNextChild = currentChild.getNextSibling();
                fragment.removeChild(currentChild);
                this.insertBefore(currentChild, refChild);
                currentChild = savedNextChild;
            }
        } else {
            Node _parent = newChild.getParentNode();
            if (_parent != null) {
                _parent.removeChild(newChild);
            }
            try {
                this.treeInsertBefore((DOMNode)newChild, (DOMNode)refChild);
            }
            catch (FrameworkException frex) {
                if (frex.getStatus() == 404) {
                    throw new DOMException(8, frex.getMessage());
                }
                throw new DOMException(11, frex.getMessage());
            }
            this.handleNewChild(newChild);
        }
        return refChild;
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        this.checkWriteAccess();
        this.checkSameDocument(newChild);
        this.checkSameDocument(oldChild);
        this.checkHierarchy(newChild);
        this.checkHierarchy(oldChild);
        if (newChild instanceof DocumentFragment) {
            DocumentFragment fragment = (DocumentFragment)newChild;
            Node currentChild = fragment.getFirstChild();
            while (currentChild != null) {
                Node savedNextChild = currentChild.getNextSibling();
                fragment.removeChild(currentChild);
                this.insertBefore(currentChild, oldChild);
                currentChild = savedNextChild;
            }
            this.removeChild(oldChild);
        } else {
            Node _parent = newChild.getParentNode();
            if (_parent != null && _parent instanceof DOMNode) {
                _parent.removeChild(newChild);
            }
            try {
                this.treeReplaceChild((DOMNode)newChild, (DOMNode)oldChild);
            }
            catch (FrameworkException frex) {
                if (frex.getStatus() == 404) {
                    throw new DOMException(8, frex.getMessage());
                }
                throw new DOMException(11, frex.getMessage());
            }
            this.handleNewChild(newChild);
        }
        return oldChild;
    }

    @Override
    public Node removeChild(Node node) throws DOMException {
        this.checkWriteAccess();
        this.checkSameDocument(node);
        this.checkIsChild(node);
        try {
            this.treeRemoveChild((DOMNode)node);
        }
        catch (FrameworkException fex) {
            throw new DOMException(11, fex.toString());
        }
        return node;
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        this.checkWriteAccess();
        this.checkSameDocument(newChild);
        this.checkHierarchy(newChild);
        try {
            if (newChild instanceof DocumentFragment) {
                DocumentFragment fragment = (DocumentFragment)newChild;
                Node currentChild = fragment.getFirstChild();
                while (currentChild != null) {
                    Node savedNextChild = currentChild.getNextSibling();
                    fragment.removeChild(currentChild);
                    this.appendChild(currentChild);
                    currentChild = savedNextChild;
                }
            } else {
                Node _parent = newChild.getParentNode();
                if (_parent != null && _parent instanceof DOMNode) {
                    _parent.removeChild(newChild);
                }
                this.treeAppendChild((DOMNode)newChild);
                this.handleNewChild(newChild);
            }
        }
        catch (FrameworkException fex) {
            throw new DOMException(11, fex.toString());
        }
        return newChild;
    }

    @Override
    public boolean hasChildNodes() {
        return !((List)this.getProperty((PropertyKey)children)).isEmpty();
    }

    @Override
    public Node cloneNode(boolean deep) {
        if (deep) {
            return DOMNode.cloneAndAppendChildren(this.securityContext, this);
        }
        PropertyMap properties = new PropertyMap();
        for (PropertyKey key : this.getPropertyKeys(uiView.name())) {
            if (!key.equals(GraphObject.type) && (key.isUnvalidated() || key.equals(GraphObject.id) || key.equals(ownerDocument) || key.equals(pageId) || key.equals(parent) || key.equals(parentId) || key.equals(DOMElement.syncedNodes) || key.equals(children) || key.equals(childrenIds))) continue;
            properties.put(key, this.getProperty(key));
        }
        for (PropertyKey key : this.getPropertyKeys(DOMElement.htmlView.name())) {
            if (!key.equals(GraphObject.type) && (key.isUnvalidated() || key.equals(GraphObject.id) || key.equals(ownerDocument) || key.equals(pageId) || key.equals(parent) || key.equals(parentId) || key.equals(DOMElement.syncedNodes) || key.equals(children) || key.equals(childrenIds))) continue;
            properties.put(key, this.getProperty(key));
        }
        if (this instanceof LinkSource) {
            LinkSource linkSourceElement = (LinkSource)this;
            properties.put(LinkSource.linkable, linkSourceElement.getProperty((PropertyKey)LinkSource.linkable));
        }
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        try {
            DOMNode node = (DOMNode)app.create(this.getClass(), properties);
            return node;
        }
        catch (FrameworkException ex) {
            throw new DOMException(11, ex.toString());
        }
    }

    @Override
    public boolean isSupported(String string, String string1) {
        return false;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public void setPrefix(String prefix) throws DOMException {
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public short compareDocumentPosition(Node node) throws DOMException {
        return 0;
    }

    @Override
    public boolean isSameNode(Node node) {
        if (node != null && node instanceof DOMNode) {
            String otherId = (String)((DOMNode)node).getProperty((PropertyKey)GraphObject.id);
            String ourId = (String)this.getProperty((PropertyKey)GraphObject.id);
            if (ourId != null && otherId != null && ourId.equals(otherId)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public String lookupPrefix(String string) {
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String string) {
        return true;
    }

    @Override
    public String lookupNamespaceURI(String string) {
        return null;
    }

    @Override
    public boolean isEqualNode(Node node) {
        return this.equals(node);
    }

    @Override
    public Object getFeature(String string, String string1) {
        return null;
    }

    @Override
    public Object setUserData(String string, Object o, UserDataHandler udh) {
        return null;
    }

    @Override
    public Object getUserData(String string) {
        return null;
    }

    @Override
    public final void normalize() {
        Document document = this.getOwnerDocument();
        if (document != null) {
            Node child = this.getFirstChild();
            while (child != null) {
                if (child instanceof Text) {
                    Node next = child.getNextSibling();
                    if (next != null && next instanceof Text) {
                        String text1 = child.getNodeValue();
                        String text2 = next.getNodeValue();
                        Text newText = document.createTextNode(text1.concat(text2));
                        this.removeChild(child);
                        this.insertBefore(newText, next);
                        this.removeChild(next);
                        child = newText;
                        continue;
                    }
                    child = next;
                    continue;
                }
                child = child.getNextSibling();
            }
            if (this.hasChildNodes()) {
                for (Node currentChild = this.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                    currentChild.normalize();
                }
            }
        }
    }

    @Override
    public Node doAdopt(Page _page) throws DOMException {
        if (_page != null) {
            try {
                this.setProperties(this.securityContext, new PropertyMap(ownerDocument, (Object)_page));
            }
            catch (FrameworkException fex) {
                throw new DOMException(11, fex.getMessage());
            }
        }
        return this;
    }

    public static GraphObjectMap extractHeaders(Header[] headers) {
        GraphObjectMap map = new GraphObjectMap();
        for (Header header : headers) {
            map.put((PropertyKey)new StringProperty(header.getName()), (Object)header.getValue());
        }
        return map;
    }

    public static Set<DOMNode> getAllChildNodes(DOMNode node) {
        HashSet<DOMNode> allChildNodes = new HashSet<DOMNode>();
        DOMNode.getAllChildNodes(node, allChildNodes);
        return allChildNodes;
    }

    private static void getAllChildNodes(DOMNode node, Set<DOMNode> allChildNodes) {
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof DOMNode)) continue;
            DOMNode domNode = (DOMNode)n;
            if (allChildNodes.contains(domNode)) break;
            allChildNodes.add(domNode);
            allChildNodes.addAll(DOMNode.getAllChildNodes(domNode));
        }
    }

    public static DOMNode cloneAndAppendChildren(SecurityContext securityContext, DOMNode nodeToClone) {
        DOMNode newNode = (DOMNode)nodeToClone.cloneNode(false);
        List childrenToClone = (List)((Object)nodeToClone.getChildNodes());
        for (DOMNode childNodeToClone : childrenToClone) {
            DOMNode newChildNode = DOMNode.cloneAndAppendChildren(securityContext, childNodeToClone);
            newNode.appendChild(newChildNode);
        }
        return newNode;
    }

    public List<GraphObject> getSyncData() throws FrameworkException {
        List data = super.getSyncData();
        data.addAll((Collection)this.getProperty((PropertyKey)children));
        DOMNode sibling = (DOMNode)this.getProperty((PropertyKey)nextSibling);
        if (sibling != null) {
            data.add(sibling);
        }
        for (DOMChildren child : this.getOutgoingRelationships(DOMChildren.class)) {
            data.add(child);
        }
        DOMSiblings siblingRel = (DOMSiblings)this.getOutgoingRelationship(DOMSiblings.class);
        if (siblingRel != null) {
            data.add(siblingRel);
        }
        data.add(this.getProperty((PropertyKey)sharedComponent));
        data.add(this.getIncomingRelationship(Sync.class));
        data.add(this.getProperty((PropertyKey)ownerDocument));
        data.add(this.getOutgoingRelationship(PageLink.class));
        data.add(this.getProperty((PropertyKey)parent));
        data.add(this.getIncomingRelationship(DOMChildren.class));
        return data;
    }

    public static String objectToString(Object source) {
        if (source != null) {
            return source.toString();
        }
        return null;
    }

    public Document getOwnerDocumentAsSuperUser() {
        PageLink ownership;
        if (this.cachedOwnerDocument == null && (ownership = (PageLink)this.getOutgoingRelationshipAsSuperUser(PageLink.class)) != null) {
            Page page;
            this.cachedOwnerDocument = page = (Page)ownership.getTargetNode();
        }
        return this.cachedOwnerDocument;
    }

    public synchronized Map<String, Integer> getMostUsedElementNames() {
        if (this.cachedMostUsedTagNames == null) {
            this.cachedMostUsedTagNames = new LinkedHashMap<String, Integer>();
            this.getMostUsedElementNames(this.cachedMostUsedTagNames, this, 0);
        }
        return this.cachedMostUsedTagNames;
    }

    public String getPagePath() {
        if (this.cachedPagePath == null) {
            StringBuilder buf = new StringBuilder();
            for (DOMNode current = this; current != null; current = (DOMNode)current.getProperty((PropertyKey)parent)) {
                buf.insert(0, "/" + current.getContextName());
            }
            this.cachedPagePath = buf.toString();
        }
        return this.cachedPagePath;
    }

    public void setVisibility(boolean publicUsers, boolean authenticatedUsers) throws FrameworkException {
        PropertyMap map = new PropertyMap();
        map.put((PropertyKey)NodeInterface.visibleToPublicUsers, (Object)publicUsers);
        map.put((PropertyKey)NodeInterface.visibleToAuthenticatedUsers, (Object)authenticatedUsers);
        this.setProperties(this.securityContext, map);
    }

    private void getMostUsedElementNames(Map<String, Integer> mostUsedElements, DOMNode parent, int depth) {
        for (DOMNode node : (List)parent.getProperty((PropertyKey)children)) {
            String tag = (String)node.getProperty((PropertyKey)DOMElement.tag);
            if (tag != null && !Page.nonBodyTags.contains(tag)) {
                Integer value = this.cachedMostUsedTagNames.get(tag);
                if (value == null) {
                    this.cachedMostUsedTagNames.put(tag, 1);
                } else {
                    this.cachedMostUsedTagNames.put(tag, value + 1);
                }
            }
            this.getMostUsedElementNames(mostUsedElements, node, depth + 1);
        }
    }

    private boolean checkName(ErrorBuffer errorBuffer) {
        String _name = (String)this.getProperty((PropertyKey)AbstractNode.name);
        if (_name != null && _name.contains("/")) {
            errorBuffer.add((ErrorToken)new SemanticErrorToken(this.getType(), (PropertyKey)AbstractNode.name, "may_not_contain_slashes", (Object)_name));
            return false;
        }
        return true;
    }

    static {
        listSources.add(new IdRequestParameterGraphDataSource("nodeId"));
        listSources.add(new RestDataSource());
        listSources.add(new NodeGraphDataSource());
        listSources.add(new FunctionDataSource());
        listSources.add(new CypherGraphDataSource());
        listSources.add(new XPathGraphDataSource());
        dataKey = new StringProperty("dataKey").indexed();
        cypherQuery = new StringProperty("cypherQuery");
        xpathQuery = new StringProperty("xpathQuery");
        restQuery = new StringProperty("restQuery");
        functionQuery = new StringProperty("functionQuery");
        renderDetails = new BooleanProperty("renderDetails");
        syncedNodes = new EndNodes("syncedNodes", Sync.class, (Notion)new PropertyNotion((PropertyKey)id));
        sharedComponent = new StartNode("sharedComponent", Sync.class, (Notion)new PropertyNotion((PropertyKey)id));
        sharedComponentConfiguration = new StringProperty("sharedComponentConfiguration").format("multi-line");
        hideOnIndex = new BooleanProperty("hideOnIndex").indexed();
        hideOnDetail = new BooleanProperty("hideOnDetail").indexed();
        showForLocales = new StringProperty("showForLocales").indexed();
        hideForLocales = new StringProperty("hideForLocales").indexed();
        showConditions = new StringProperty("showConditions").indexed();
        hideConditions = new StringProperty("hideConditions").indexed();
        parent = new StartNode("parent", DOMChildren.class);
        parentId = new EntityIdProperty("parentId", parent);
        children = new EndNodes("children", DOMChildren.class);
        childrenIds = new CollectionIdProperty("childrenIds", children);
        previousSibling = new StartNode("previousSibling", DOMSiblings.class);
        nextSibling = new EndNode("nextSibling", DOMSiblings.class);
        nextSiblingId = new EntityIdProperty("nextSiblingId", nextSibling);
        ownerDocument = new EndNode("ownerDocument", PageLink.class);
        pageId = new EntityIdProperty("pageId", ownerDocument);
        isDOMNode = new ConstantBooleanProperty("isDOMNode", true);
        dataStructrIdProperty = new StringProperty("data-structr-id");
        dataHashProperty = new StringProperty("data-structr-hash");
        domSortPosition = new IntProperty("domSortPosition");
        rawProps = new Property[]{dataKey, restQuery, cypherQuery, xpathQuery, functionQuery, hideOnIndex, hideOnDetail, showForLocales, hideForLocales, showConditions, hideConditions};
    }

    protected static class TagPredicate
    implements Predicate<Node> {
        private String tagName = null;

        public TagPredicate(String tagName) {
            this.tagName = tagName;
        }

        public boolean accept(Node obj) {
            DOMElement elem;
            return obj instanceof DOMElement && this.tagName.equals((elem = (DOMElement)obj).getProperty((PropertyKey)DOMElement.tag));
        }
    }

    protected static class TextCollector
    implements Predicate<Node> {
        private final StringBuilder textBuffer = new StringBuilder(200);

        protected TextCollector() {
        }

        public boolean accept(Node obj) {
            if (obj instanceof Text) {
                this.textBuffer.append(((Text)obj).getTextContent());
            }
            return false;
        }

        public String getText() {
            return this.textBuffer.toString();
        }
    }
}

