/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.entity.html;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.View;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.common.HtmlProperty;
import org.structr.web.entity.LinkSource;
import org.structr.web.entity.dom.Content;
import org.w3c.dom.Node;

public class Script
extends LinkSource {
    private static final Logger logger = LoggerFactory.getLogger((String)Script.class.getName());
    public static final Property<String> _src = new HtmlProperty("src");
    public static final Property<String> _async = new HtmlProperty("async");
    public static final Property<String> _defer = new HtmlProperty("defer");
    public static final Property<String> _type = new HtmlProperty("type");
    public static final Property<String> _charset = new HtmlProperty("charset");
    public static final View uiView = new View(Script.class, "ui", new Property[]{linkableId, linkable});
    public static final View htmlView = new View(Script.class, "_html_", new Property[]{_src, _async, _defer, _type, _charset});

    @Override
    public boolean onCreation(SecurityContext securityContext, ErrorBuffer errorBuffer) throws FrameworkException {
        if (super.isValid(errorBuffer)) {
            this.setProperty((PropertyKey)_type, "text/javascript");
            return true;
        }
        return false;
    }

    @Override
    public Property[] getHtmlAttributes() {
        return (Property[])ArrayUtils.addAll((Object[])super.getHtmlAttributes(), (Object[])htmlView.properties());
    }

    @Override
    protected void handleNewChild(Node newChild) {
        if (newChild instanceof Content) {
            try {
                String scriptType = (String)this.getProperty((PropertyKey)_type);
                if (StringUtils.isNotBlank((String)scriptType)) {
                    ((Content)newChild).setProperties(this.securityContext, new PropertyMap(Content.contentType, (Object)scriptType));
                }
            }
            catch (FrameworkException fex) {
                logger.warn("Unable to set property on new child: {}", (Object)fex.getMessage());
            }
        }
    }
}

