/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import java.util.LinkedList;
import java.util.List;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.function.XmlFunction;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.Property;
import org.structr.core.property.StringProperty;
import org.structr.schema.action.ActionContext;
import org.structr.web.function.UiFunction;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FromXmlFunction
extends UiFunction {
    private static final Property<List> attributesProperty = new GenericProperty("attributes");
    private static final Property<List> childrenProperty = new GenericProperty("children");
    private static final Property<String> valueProperty = new StringProperty("value");
    private static final Property<String> nameProperty = new StringProperty("name");
    private static final Property<String> typeProperty = new StringProperty("type");
    public static final String ERROR_MESSAGE_FROM_XML = "Usage: ${from_xml(source)}. Example: ${from_xml('<entry>0</entry>')}";
    public static final String ERROR_MESSAGE_FROM_XML_JS = "Usage: ${{Structr.from_xml(src)}}. Example: ${{Structr.from_xml('<entry>0</entry>')}}";

    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        if (sources != null && sources.length > 0) {
            if (sources[0] == null) {
                return "";
            }
            try {
                GraphObjectMap result = new GraphObjectMap();
                XmlFunction xml = new XmlFunction();
                Document document = (Document)xml.apply(ctx, caller, sources);
                if (document != null) {
                    this.convertNode(result, document);
                    return result;
                }
                logger.warn("Unable to parse XML document: {}", (Object)sources[0].toString());
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
            }
            return "";
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_FROM_XML_JS : ERROR_MESSAGE_FROM_XML;
    }

    public String shortDescription() {
        return "Parses the given XML and returns a list of objects.";
    }

    public String getName() {
        return "from_xml";
    }

    private void convertNode(GraphObjectMap map, Node node) {
        String nodeValue;
        NamedNodeMap attributeList;
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            LinkedList<GraphObjectMap> children = new LinkedList<GraphObjectMap>();
            int length = nodeList.getLength();
            for (int i = 0; i < length; ++i) {
                GraphObjectMap childMap = new GraphObjectMap();
                Node childNode = nodeList.item(i);
                this.convertNode(childMap, childNode);
                children.add(childMap);
            }
            map.put(childrenProperty, children);
        }
        if ((attributeList = node.getAttributes()) != null) {
            LinkedList<GraphObjectMap> attributes = new LinkedList<GraphObjectMap>();
            int length = attributeList.getLength();
            for (int i = 0; i < length; ++i) {
                GraphObjectMap attributeMap = new GraphObjectMap();
                Node attributeNode = attributeList.item(i);
                this.convertNode(attributeMap, attributeNode);
                attributes.add(attributeMap);
            }
            map.put(attributesProperty, attributes);
        }
        map.put(typeProperty, (Object)node.getClass().getSimpleName());
        String nodeName = node.getNodeName();
        if (nodeName != null) {
            map.put(nameProperty, (Object)nodeName);
        }
        if ((nodeValue = node.getNodeValue()) != null) {
            map.put(valueProperty, (Object)nodeValue);
        }
    }
}

