/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import javax.servlet.http.HttpServletRequest;
import org.structr.common.SecurityContext;
import org.structr.schema.action.ActionContext;
import org.structr.web.function.UiFunction;

public class GetRequestHeaderFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_GET_REQUEST_HEADER = "Usage: ${get_request_header(name)}. Example: ${get_request_header('User-Agent')}";
    public static final String ERROR_MESSAGE_GET_REQUEST_HEADER_JS = "Usage: ${{Structr.getRequestHeader(name)}}. Example: ${{Structr.getRequestHeader('User-Agent')}}";

    public String getName() {
        return "get_request_header()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) {
        try {
            HttpServletRequest request;
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 1)) {
                return null;
            }
            SecurityContext securityContext = ctx.getSecurityContext();
            String name = sources[0].toString();
            if (securityContext != null && (request = securityContext.getRequest()) != null) {
                return request.getHeader(name);
            }
            return "";
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_GET_REQUEST_HEADER_JS : ERROR_MESSAGE_GET_REQUEST_HEADER;
    }

    public String shortDescription() {
        return "Returns the value of the given request header field";
    }
}

