/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import org.structr.schema.action.ActionContext;
import org.structr.web.function.UiFunction;

public class HttpHeadFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_HEAD = "Usage: ${HEAD(URL[, username, password])}. Example: ${HEAD('http://structr.org', 'foo', 'bar')}";
    public static final String ERROR_MESSAGE_HEAD_JS = "Usage: ${{Structr.HEAD(URL[, username, password]])}}. Example: ${{Structr.HEAD('http://structr.org', 'foo', 'bar')}}";

    public String getName() {
        return "HEAD()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) {
        if (sources != null && sources.length >= 1 && sources.length <= 3) {
            try {
                String address = sources[0].toString();
                String username = null;
                String password = null;
                switch (sources.length) {
                    case 3: {
                        password = sources[2].toString();
                    }
                    case 2: {
                        username = sources[1].toString();
                    }
                }
                return this.headFromUrl(ctx, address, username, password);
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
                return "";
            }
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_HEAD_JS : ERROR_MESSAGE_HEAD;
    }

    public String shortDescription() {
        return "Sends an HTTP HEAD request to the given URL and returns the response headers";
    }
}

