/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.structr.core.GraphObjectMap;
import org.structr.schema.action.ActionContext;
import org.structr.web.common.microformat.MicroformatParser;
import org.structr.web.function.UiFunction;

public class ParseFunction
extends UiFunction {
    public static final String ERROR_MESSAGE_PARSE = "Usage: ${parse(URL, selector)}. Example: ${parse('http://structr.org', 'li.data')}";
    public static final String ERROR_MESSAGE_PARSE_JS = "Usage: ${{Structr.parse(URL, selector)}}. Example: ${{Structr.parse('http://structr.org', 'li.data')}}";

    public String getName() {
        return "parse()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) {
        if (sources != null && sources.length == 2) {
            try {
                String source = sources[0].toString();
                String selector = sources[1].toString();
                List<Map<String, Object>> objects = new MicroformatParser().parse(source, selector);
                LinkedList<GraphObjectMap> elements = new LinkedList<GraphObjectMap>();
                for (Map<String, Object> map : objects) {
                    GraphObjectMap obj = new GraphObjectMap();
                    elements.add(obj);
                    ParseFunction.recursivelyConvertMapToGraphObjectMap((GraphObjectMap)obj, map, (int)0);
                }
                return elements;
            }
            catch (Throwable t) {
                this.logException(caller, t, sources);
                return "";
            }
        }
        this.logParameterError(caller, sources, ctx.isJavaScriptContext());
        return this.usage(ctx.isJavaScriptContext());
    }

    public String usage(boolean inJavaScriptContext) {
        return inJavaScriptContext ? ERROR_MESSAGE_PARSE_JS : ERROR_MESSAGE_PARSE;
    }

    public String shortDescription() {
        return "Parses the given string and returns an object";
    }
}

