/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.function;

import org.apache.commons.mail.EmailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.MailHelper;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class SendPlaintextMailFunction
extends Function<Object, Object> {
    private static final Logger logger = LoggerFactory.getLogger((String)SendPlaintextMailFunction.class.getName());
    public static final String ERROR_MESSAGE_SEND_PLAINTEXT_MAIL = "Usage: ${send_plaintext_mail(fromAddress, fromName, toAddress, toName, subject, content)}.";

    public String getName() {
        return "send_plaintext_mail()";
    }

    public Object apply(ActionContext ctx, Object caller, Object[] sources) throws FrameworkException {
        try {
            if (!this.arrayHasLengthAndAllElementsNotNull(sources, 6)) {
                return null;
            }
            String from = sources[0].toString();
            String fromName = sources[1].toString();
            String to = sources[2].toString();
            String toName = sources[3].toString();
            String subject = sources[4].toString();
            String textContent = sources[5].toString();
            try {
                return MailHelper.sendSimpleMail((String)from, (String)fromName, (String)to, (String)toName, null, null, (String)from, (String)subject, (String)textContent);
            }
            catch (EmailException eex) {
                this.logException(caller, eex, sources);
            }
        }
        catch (IllegalArgumentException e) {
            this.logParameterError(caller, sources, ctx.isJavaScriptContext());
            return this.usage(ctx.isJavaScriptContext());
        }
        return "";
    }

    public String usage(boolean inJavaScriptContext) {
        return ERROR_MESSAGE_SEND_PLAINTEXT_MAIL;
    }

    public String shortDescription() {
        return "Sends a plaintext e-mail";
    }
}

