/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.maintenance.deploy;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.schema.export.StructrSchema;
import org.structr.schema.json.JsonSchema;

public class SchemaImportVisitor
implements FileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger((String)SchemaImportVisitor.class.getName());
    private Path basePath = null;

    public SchemaImportVisitor(Path basePath) {
        this.basePath = basePath;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        String fileName;
        if (attrs.isRegularFile() && (fileName = file.getFileName().toString()).endsWith(".json")) {
            SecurityContext ctx = SecurityContext.getSuperUserInstance();
            ctx.setDoTransactionNotifications(false);
            App app = StructrApp.getInstance((SecurityContext)ctx);
            try (FileReader reader = new FileReader(file.toFile());){
                StructrSchema.replaceDatabaseSchema((App)app, (JsonSchema)StructrSchema.createFromSource((Reader)reader));
            }
            catch (Throwable t) {
                logger.warn("", t);
            }
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

