/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.maintenance.deploy;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.NodeAttribute;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.Tx;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Template;
import org.structr.web.importer.Importer;
import org.structr.web.maintenance.DeployCommand;
import org.structr.websocket.command.CreateComponentCommand;

public class TemplateImportVisitor
implements FileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger((String)TemplateImportVisitor.class.getName());
    private static final GenericProperty internalSharedTemplateKey = new GenericProperty("shared");
    private Map<String, Object> configuration = null;
    private SecurityContext securityContext = null;
    private App app = null;

    public TemplateImportVisitor(Map<String, Object> pagesConfiguration) {
        this.configuration = pagesConfiguration;
        this.securityContext = SecurityContext.getSuperUserInstance();
        this.securityContext.setDoTransactionNotifications(false);
        this.app = StructrApp.getInstance((SecurityContext)this.securityContext);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (attrs.isRegularFile()) {
            String fileName = file.getFileName().toString();
            if (fileName.endsWith(".html")) {
                try {
                    this.createTemplate(file, fileName);
                }
                catch (FrameworkException fex) {
                    logger.warn("Exception while importing shared component {}: {}", new Object[]{NodeInterface.name, fex.getMessage()});
                }
            }
        } else {
            logger.warn("Unexpected directory {} found in components/ directory, ignoring", (Object)file.getFileName().toString());
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        logger.warn("Exception while importing file {}: {}", new Object[]{file.toString(), exc.getMessage()});
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DOMNode getExistingTemplate(String name) {
        try (Tx tx = this.app.tx();){
            DOMNode dOMNode = Importer.findSharedComponentByName(name);
            return dOMNode;
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to determine if template {} already exists, ignoring.", (Object)name);
            return null;
        }
    }

    private void deleteTemplate(App app, DOMNode template) throws FrameworkException {
        if (template != null) {
            this.deleteRecursively(app, template);
        }
    }

    private void deleteRecursively(App app, DOMNode node) throws FrameworkException {
        for (DOMNode child : node.treeGetChildren()) {
            this.deleteRecursively(app, child);
        }
        app.delete((NodeInterface)node);
    }

    private PropertyMap getPropertiesForTemplate(String name) {
        Object data = this.configuration.get(name);
        if (data != null && data instanceof Map) {
            try {
                return PropertyMap.inputTypeToJavaType((SecurityContext)SecurityContext.getSuperUserInstance(), DOMNode.class, (Map)((Map)data));
            }
            catch (FrameworkException ex) {
                logger.warn("Unable to resolve properties for template: {}", (Object)ex.getMessage());
            }
        }
        return new PropertyMap();
    }

    private void createTemplate(Path file, String fileName) throws IOException, FrameworkException {
        String templateName = StringUtils.substringBeforeLast((String)fileName, (String)".html");
        boolean byId = DeployCommand.isUuid(templateName);
        try (Tx tx = this.app.tx(true, false, false);){
            Template template;
            DOMNode existingTemplate;
            String name = byId ? null : templateName;
            PropertyMap properties = this.getPropertiesForTemplate(templateName);
            logger.info("Importing template {} from {}..", new Object[]{templateName, fileName});
            String src = new String(Files.readAllBytes(file), Charset.forName("UTF-8"));
            if (byId) {
                existingTemplate = (DOMNode)this.app.get(templateName);
                if (existingTemplate != null) {
                    this.deleteTemplate(this.app, existingTemplate);
                }
                template = (Template)this.app.create(Template.class, new NodeAttribute[]{new NodeAttribute((PropertyKey)AbstractNode.id, (Object)templateName)});
            } else {
                existingTemplate = this.getExistingTemplate(name);
                if (existingTemplate != null) {
                    this.deleteTemplate(this.app, existingTemplate);
                }
                template = (Template)this.app.create(Template.class, new NodeAttribute[0]);
                properties.put((PropertyKey)Template.name, (Object)name);
            }
            properties.put((PropertyKey)Template.content, (Object)src);
            Object value = properties.get((PropertyKey)internalSharedTemplateKey);
            if (value != null) {
                if ("true".equals(value)) {
                    template.setProperty((PropertyKey)DOMNode.ownerDocument, CreateComponentCommand.getOrCreateHiddenDocument());
                }
                properties.remove((PropertyKey)internalSharedTemplateKey);
            }
            template.setProperties(this.securityContext, properties);
            tx.success();
        }
        catch (Throwable t) {
            logger.debug("Error trying to create template {}", (Object)fileName);
        }
    }
}

