/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.property;

import org.apache.commons.lang3.StringUtils;
import org.structr.api.Predicate;
import org.structr.api.search.SortType;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.property.AbstractReadOnlyProperty;
import org.structr.core.property.Property;
import org.structr.web.entity.Image;

public class ThumbnailProperty
extends AbstractReadOnlyProperty<Image> {
    private int width = 0;
    private int height = 0;
    private boolean crop = false;

    public ThumbnailProperty(String name) {
        super(name);
        this.unvalidated = true;
    }

    public Image getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter) {
        return this.getProperty(securityContext, obj, applyConverter, (Predicate)null);
    }

    public Image getProperty(SecurityContext securityContext, GraphObject obj, boolean applyConverter, Predicate<GraphObject> predicate) {
        if (((Boolean)obj.getProperty(Image.isThumbnail)).booleanValue()) {
            return null;
        }
        return ((Image)obj).getScaledImage(this.width, this.height, this.crop);
    }

    public Class relatedType() {
        return Image.class;
    }

    public Class valueType() {
        return this.relatedType();
    }

    public boolean isCollection() {
        return false;
    }

    public SortType getSortType() {
        return null;
    }

    public Property<Image> format(String format) {
        String[] parts;
        if (StringUtils.isNotBlank((CharSequence)format) && format.contains(",") && (parts = format.split("[, ]+")).length == 3) {
            this.width = Integer.parseInt(parts[0].trim());
            this.height = Integer.parseInt(parts[1].trim());
            this.crop = Boolean.parseBoolean(parts[2].trim());
        }
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean getCrop() {
        return this.crop;
    }
}

