/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.servlet;

import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.AccessMode;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.StructrApp;
import org.structr.core.auth.exception.AuthenticationException;
import org.structr.core.graph.Tx;
import org.structr.rest.service.HttpServiceServlet;
import org.structr.rest.service.StructrHttpServiceConfig;
import org.structr.schema.SchemaHelper;
import org.structr.web.auth.UiAuthenticator;
import org.structr.web.maintenance.DeployCommand;

public class DeploymentServlet
extends HttpServlet
implements HttpServiceServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)DeploymentServlet.class.getName());
    private static final int MEGABYTE = 0x100000;
    private static final int MEMORY_THRESHOLD = 0xA00000;
    private ServletFileUpload uploader = null;
    private File filesDir = null;
    private final StructrHttpServiceConfig config = new StructrHttpServiceConfig();

    @Override
    public StructrHttpServiceConfig getConfig() {
        return this.config;
    }

    public String getModuleName() {
        return "deployment";
    }

    public void init() {
        try (Tx tx = StructrApp.getInstance().tx();){
            DiskFileItemFactory fileFactory = new DiskFileItemFactory();
            fileFactory.setSizeThreshold(0xA00000);
            this.filesDir = new File((String)Settings.TmpPath.getValue());
            if (!this.filesDir.exists()) {
                this.filesDir.mkdir();
            }
            fileFactory.setRepository(this.filesDir);
            this.uploader = new ServletFileUpload((FileItemFactory)fileFactory);
            tx.success();
        }
        catch (FrameworkException t) {
            logger.warn("", (Throwable)t);
        }
    }

    public void destroy() {
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        try (Tx tx = StructrApp.getInstance().tx();){
            SecurityContext securityContext;
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
                response.setStatus(400);
                response.getOutputStream().write("ERROR (400): Request does not contain multipart content.\n".getBytes("UTF-8"));
                return;
            }
            try {
                securityContext = this.getConfig().getAuthenticator().initializeAndExamineRequest(request, response);
            }
            catch (AuthenticationException ae) {
                response.setStatus(401);
                response.getOutputStream().write("ERROR (401): Invalid user or password.\n".getBytes("UTF-8"));
                if (tx != null) {
                    if (var4_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
                return;
            }
            if (securityContext.getUser(false) == null && !((Boolean)Settings.DeploymentAllowAnonymousUploads.getValue()).booleanValue()) {
                response.setStatus(401);
                response.getOutputStream().write("ERROR (401): Anonymous uploads forbidden.\n".getBytes("UTF-8"));
                return;
            }
            securityContext.setAccessMode(AccessMode.Frontend);
            request.setCharacterEncoding("UTF-8");
            response.setCharacterEncoding("UTF-8");
            if (response.getStatus() == 302) {
                return;
            }
            String pathInfo = request.getPathInfo();
            String type = null;
            if (StringUtils.isNotBlank((String)pathInfo)) {
                type = SchemaHelper.normalizeEntityName((String)StringUtils.stripStart((String)pathInfo.trim(), (String)"/"));
            }
            this.uploader.setFileSizeMax((long)(0x100000 * (Integer)Settings.DeploymentMaxFileSize.getValue()));
            this.uploader.setSizeMax((long)(0x100000 * (Integer)Settings.DeploymentMaxRequestSize.getValue()));
            response.setContentType("text/html");
            List fileItemsList = this.uploader.parseRequest(request);
            Iterator fileItemsIterator = fileItemsList.iterator();
            HashMap params = new HashMap();
            while (fileItemsIterator.hasNext()) {
                FileItem item = (FileItem)fileItemsIterator.next();
                try {
                    String directoryPath = "/tmp/" + UUID.randomUUID();
                    String filePath = directoryPath + ".zip";
                    File file = new File(filePath);
                    Files.write((byte[])IOUtils.toByteArray((InputStream)item.getInputStream()), (File)file);
                    this.unzip(file, directoryPath);
                    DeployCommand deployCommand = (DeployCommand)StructrApp.getInstance((SecurityContext)securityContext).command(DeployCommand.class);
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("source", directoryPath + "/" + StringUtils.substringBeforeLast((String)item.getName(), (String)"."));
                    deployCommand.execute(attributes);
                    file.deleteOnExit();
                    File dir = new File(directoryPath);
                    dir.deleteOnExit();
                }
                catch (IOException ex) {
                    logger.warn("Could not upload file", (Throwable)ex);
                }
            }
            tx.success();
        }
        catch (IOException | FileUploadException | FrameworkException t) {
            logger.error("Exception while processing request", t);
            UiAuthenticator.writeInternalServerError(response);
        }
    }

    private void unzip(File file, String outputDir) throws IOException {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File targetFile = new File(outputDir, entry.getName());
                if (entry.isDirectory()) {
                    targetFile.mkdirs();
                    continue;
                }
                targetFile.getParentFile().mkdirs();
                InputStream in = zipFile.getInputStream(entry);
                FileOutputStream out = new FileOutputStream(targetFile);
                Throwable throwable = null;
                try {
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    IOUtils.closeQuietly((InputStream)in);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((OutputStream)out).close();
                }
            }
        }
    }
}

