/*
 * Decompiled with CFR 0.152.
 */
package org.structr.web.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.AccessMode;
import org.structr.common.SecurityContext;
import org.structr.core.app.StructrApp;
import org.structr.core.auth.Authenticator;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.rest.common.HttpHelper;
import org.structr.rest.service.HttpServiceServlet;
import org.structr.rest.service.StructrHttpServiceConfig;
import org.structr.web.auth.UiAuthenticator;
import org.structr.web.entity.User;
import org.structr.web.entity.dom.Page;

public class ProxyServlet
extends HttpServlet
implements HttpServiceServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)ProxyServlet.class.getName());
    public static final String CONFIRM_REGISTRATION_PAGE = "/confirm_registration";
    public static final String RESET_PASSWORD_PAGE = "/reset-password";
    public static final String POSSIBLE_ENTRY_POINTS_KEY = "possibleEntryPoints";
    public static final String DOWNLOAD_AS_FILENAME_KEY = "filename";
    public static final String RANGE_KEY = "range";
    public static final String DOWNLOAD_AS_DATA_URL_KEY = "as-data-url";
    public static final String CONFIRM_KEY_KEY = "key";
    public static final String TARGET_PAGE_KEY = "target";
    public static final String ERROR_PAGE_KEY = "onerror";
    public static final String CUSTOM_RESPONSE_HEADERS = "HtmlServlet.customResponseHeaders";
    public static final String OBJECT_RESOLUTION_PROPERTIES = "HtmlServlet.resolveProperties";
    private static final String defaultCustomResponseHeaders = "Strict-Transport-Security:max-age=60,X-Content-Type-Options:nosniff,X-Frame-Options:SAMEORIGIN,X-XSS-Protection:1;mode=block";
    private static List<String> customResponseHeaders = Collections.EMPTY_LIST;
    private final StructrHttpServiceConfig config = new StructrHttpServiceConfig();
    private final Set<String> possiblePropertyNamesForEntityResolving = new LinkedHashSet<String>();

    @Override
    public StructrHttpServiceConfig getConfig() {
        return this.config;
    }

    public String getModuleName() {
        return "proxy";
    }

    public ProxyServlet() {
        String customResponseHeadersString = (String)Settings.HtmlCustomResponseHeaders.getValue();
        if (StringUtils.isBlank((CharSequence)customResponseHeadersString)) {
            customResponseHeadersString = defaultCustomResponseHeaders;
        }
        if (StringUtils.isNotBlank((CharSequence)customResponseHeadersString)) {
            customResponseHeaders = Arrays.asList(customResponseHeadersString.split("[ ,]+"));
        }
        String resolvePropertiesSource = (String)Settings.HtmlResolveProperties.getValue();
        for (String src : resolvePropertiesSource.split("[, ]+")) {
            String name = src.trim();
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            this.possiblePropertyNamesForEntityResolving.add(name);
        }
    }

    public void destroy() {
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        String content;
        Authenticator auth = this.getConfig().getAuthenticator();
        if (auth == null) {
            String errorMessage = "No authenticator class found. Check log for 'Missing authenticator key " + this.getClass().getSimpleName() + ".authenticator'";
            logger.error(errorMessage);
            try {
                ServletOutputStream out = response.getOutputStream();
                String content2 = this.errorPage(new Throwable(errorMessage));
                IOUtils.write((String)content2, (OutputStream)out);
            }
            catch (IOException ex) {
                logger.error("Could not write to response", (Throwable)ex);
            }
            return;
        }
        try {
            SecurityContext securityContext;
            try (Tx tx = StructrApp.getInstance().tx();){
                securityContext = auth.initializeAndExamineRequest(request, response);
                tx.success();
            }
            securityContext.setAccessMode(AccessMode.Frontend);
            String address = request.getParameter("url");
            URI url = URI.create(address);
            String proxyUrl = request.getParameter("proxyUrl");
            String proxyUsername = request.getParameter("proxyUsername");
            String proxyPassword = request.getParameter("proxyPassword");
            String authUsername = request.getParameter("authUsername");
            String authPassword = request.getParameter("authPassword");
            String cookie = request.getParameter("cookie");
            Principal user = securityContext.getCachedUser();
            if (user != null && StringUtils.isBlank((CharSequence)proxyUrl)) {
                proxyUrl = (String)user.getProperty((PropertyKey)User.proxyUrl);
                proxyUsername = (String)user.getProperty((PropertyKey)User.proxyUsername);
                proxyPassword = (String)user.getProperty((PropertyKey)User.proxyPassword);
            }
            content = HttpHelper.get(address, authUsername, authPassword, proxyUrl, proxyUsername, proxyPassword, cookie, Collections.EMPTY_MAP).replace("<head>", "<head>\n  <base href=\"" + url + "\">");
        }
        catch (Throwable t) {
            logger.error("Exception while processing request", t);
            content = this.errorPage(t);
        }
        try {
            ServletOutputStream out = response.getOutputStream();
            IOUtils.write((String)content, (OutputStream)out);
        }
        catch (IOException ex) {
            logger.error("Could not write to response", (Throwable)ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) {
        try {
            String string = request.getPathInfo();
        }
        catch (Throwable t) {
            logger.error("Exception while processing request", t);
            UiAuthenticator.writeInternalServerError(response);
        }
    }

    protected void doOptions(HttpServletRequest request, HttpServletResponse response) {
        Authenticator auth = this.config.getAuthenticator();
        try {
            response.setContentLength(0);
            response.setHeader("Allow", "GET,HEAD,OPTIONS");
        }
        catch (Throwable t) {
            logger.error("Exception while processing request", t);
            UiAuthenticator.writeInternalServerError(response);
        }
    }

    public static void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "private, max-age=0, s-maxage=0, no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache, no-store");
        response.setDateHeader("Expires", 0L);
    }

    private static void setCustomResponseHeaders(HttpServletResponse response) {
        for (String header : customResponseHeaders) {
            String[] keyValuePair = header.split("[ :]+");
            response.setHeader(keyValuePair[0], keyValuePair[1]);
            logger.debug("Set custom response header: {} {}", new Object[]{keyValuePair[0], keyValuePair[1]});
        }
    }

    private static boolean notModifiedSince(HttpServletRequest request, HttpServletResponse response, AbstractNode node, boolean dontCache) {
        boolean notModified = false;
        Date lastModified = node.getLastModifiedDate();
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        response.setHeader("Date", httpDateFormat.format(new Date()));
        GregorianCalendar cal = new GregorianCalendar();
        Integer seconds = (Integer)node.getProperty(Page.cacheForSeconds);
        if (!dontCache && seconds != null) {
            ((Calendar)cal).add(13, seconds);
            response.setHeader("Cache-Control", "max-age=" + seconds + ", s-maxage=" + seconds + "");
            response.setHeader("Expires", httpDateFormat.format(cal.getTime()));
        } else if (!dontCache) {
            response.setHeader("Cache-Control", "no-cache, must-revalidate, proxy-revalidate");
        } else {
            response.setHeader("Cache-Control", "private, no-cache, no-store, max-age=0, s-maxage=0, must-revalidate, proxy-revalidate");
        }
        if (lastModified != null) {
            Date roundedLastModified = DateUtils.round((Date)lastModified, (int)13);
            response.setHeader("Last-Modified", httpDateFormat.format(roundedLastModified));
            String ifModifiedSince = request.getHeader("If-Modified-Since");
            if (StringUtils.isNotBlank((CharSequence)ifModifiedSince)) {
                try {
                    Date ifModSince = httpDateFormat.parse(ifModifiedSince);
                    if (ifModSince != null && (roundedLastModified.equals(ifModSince) || roundedLastModified.before(ifModSince))) {
                        notModified = true;
                        response.setStatus(304);
                        response.setHeader("Vary", "Accept-Encoding");
                    }
                }
                catch (ParseException ex) {
                    logger.warn("Could not parse If-Modified-Since header", (Throwable)ex);
                }
            }
        }
        return notModified;
    }

    private String errorPage(Throwable t) {
        return "<html><head><title>Error in Structr Proxy</title></head><body><h1>Error in Proxy</h1><p>" + t.getMessage() + "</p>\n<!--" + ExceptionUtils.getStackTrace((Throwable)t) + "--></body></html>";
    }
}

