/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Settings;
import org.structr.common.AccessMode;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.console.Console;
import org.structr.core.GraphObject;
import org.structr.core.Services;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.auth.Authenticator;
import org.structr.core.entity.Principal;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.rest.auth.AuthHelper;
import org.structr.rest.auth.SessionHelper;
import org.structr.web.entity.FileBase;
import org.structr.web.entity.User;
import org.structr.websocket.WebsocketController;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.command.FileUploadHandler;
import org.structr.websocket.command.LoginCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class StructrWebSocket
implements WebSocketListener {
    private static final Logger logger = LoggerFactory.getLogger((String)StructrWebSocket.class.getName());
    private static final Map<String, Class> commandSet = new LinkedHashMap<String, Class>();
    private Session session = null;
    private Gson gson = null;
    private HttpServletRequest request = null;
    private SecurityContext securityContext = null;
    private WebsocketController syncController = null;
    private Map<String, FileUploadHandler> uploads = null;
    private Authenticator authenticator = null;
    private String pagePath = null;
    private Console console = null;
    private Boolean timedOut = false;

    public StructrWebSocket() {
    }

    public StructrWebSocket(WebsocketController syncController, Gson gson, Authenticator authenticator) {
        this.uploads = new LinkedHashMap<String, FileUploadHandler>();
        this.syncController = syncController;
        this.gson = gson;
        this.authenticator = authenticator;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public void onWebSocketConnect(Session session) {
        logger.debug("New connection with protocol {}", (Object)session.getProtocolVersion());
        this.session = session;
        this.syncController.registerClient(this);
        this.pagePath = this.request.getQueryString();
    }

    public void onWebSocketClose(int closeCode, String message) {
        logger.debug("Connection closed with closeCode {} and message {}", new Object[]{closeCode, message});
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        try (Tx tx = app.tx();){
            this.session = null;
            this.syncController.unregisterClient(this);
            for (FileUploadHandler upload : this.uploads.values()) {
                upload.finish();
            }
            tx.success();
            this.uploads.clear();
        }
        catch (FrameworkException fex) {
            logger.error("Error while closing connection", (Throwable)fex);
        }
    }

    public void onWebSocketText(String data) {
        Services servicesInstance = Services.getInstance();
        while (!servicesInstance.isInitialized()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (data == null) {
            logger.warn("Empty text message received.");
            return;
        }
        logger.debug("############################################################ RECEIVED \n{}", (Object)data.substring(0, Math.min(data.length(), 1000)));
        WebSocketMessage webSocketData = (WebSocketMessage)this.gson.fromJson(data, WebSocketMessage.class);
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        String command = webSocketData.getCommand();
        Class type = commandSet.get(command);
        String sessionIdFromMessage = webSocketData.getSessionId();
        if (type != null) {
            Tx tx;
            try (Tx tx2 = app.tx();){
                if (sessionIdFromMessage != null) {
                    this.authenticate(sessionIdFromMessage);
                }
                if (!this.isAuthenticated() && !type.equals(LoginCommand.class)) {
                    this.send(MessageBuilder.status().code(401).message("").build(), true);
                    tx2.success();
                    return;
                }
                tx2.success();
            }
            catch (FrameworkException t) {
                logger.warn("Unable to parse message.", (Throwable)t);
            }
            try {
                AbstractCommand abstractCommand = (AbstractCommand)type.newInstance();
                abstractCommand.setWebSocket(this);
                abstractCommand.setSession(this.session);
                abstractCommand.setCallback(webSocketData.getCallback());
                if (abstractCommand.requiresEnclosingTransaction()) {
                    tx = app.tx();
                    Throwable throwable = null;
                    try {
                        webSocketData.setSessionValid(this.isAuthenticated());
                        abstractCommand.processMessage(webSocketData);
                        tx.success();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                }
                tx = app.tx();
                Throwable throwable = null;
                try {
                    webSocketData.setSessionValid(this.isAuthenticated());
                    tx.success();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
                abstractCommand.processMessage(webSocketData);
            }
            catch (IllegalAccessException | InstantiationException | FrameworkException t) {
                try {
                    tx = app.tx();
                    Throwable throwable = null;
                    try {
                        if (t instanceof FrameworkException) {
                            FrameworkException fex = (FrameworkException)t;
                            this.send(MessageBuilder.status().code(fex.getStatus()).message(fex.toString()).jsonErrorObject(fex.toJSON()).callback(webSocketData.getCallback()).build(), true);
                        } else {
                            this.send(MessageBuilder.status().code(400).message(t.toString()).build(), true);
                        }
                        tx.success();
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                }
                catch (FrameworkException fex) {
                    logger.warn("", (Throwable)fex);
                }
                return;
            }
        } else {
            logger.warn("Unknown command {}", (Object)command);
            this.send(MessageBuilder.status().code(400).message("Unknown command").build(), true);
            return;
        }
    }

    public void send(WebSocketMessage message, boolean clearSessionId) {
        Throwable throwable;
        Tx tx;
        boolean isAuthenticated = false;
        try {
            tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();
            throwable = null;
            try {
                isAuthenticated = this.isAuthenticated();
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (FrameworkException t) {
            logger.warn("", (Throwable)t);
        }
        message.setSessionValid(isAuthenticated);
        if (clearSessionId) {
            message.setSessionId(null);
        }
        if ("LOGIN".equals(message.getCommand()) && !isAuthenticated) {
            message.setMessage("User has no backend access.");
            message.setCode(403);
        }
        try {
            tx = StructrApp.getInstance((SecurityContext)this.securityContext).tx();
            throwable = null;
            try {
                if (message.getCode() == 0) {
                    message.setCode(200);
                }
                String msg = this.gson.toJson((Object)message, WebSocketMessage.class);
                logger.debug("################### Private message: {}", (Object)message.getCommand());
                logger.debug("############################################################ SENDING \n{}", (Object)msg);
                if (this.securityContext != null) {
                    this.securityContext.clearCustomView();
                }
                this.session.getRemote().sendString(msg);
                tx.success();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (Throwable t) {
            logger.debug("Unable to send websocket message to remote client");
        }
    }

    public void createFileUploadHandler(FileBase file) {
        String uuid = (String)file.getProperty((PropertyKey)GraphObject.id);
        this.uploads.put(uuid, new FileUploadHandler(file));
    }

    public void removeFileUploadHandler(String uuid) {
        this.uploads.remove(uuid);
    }

    private FileUploadHandler handleExistingFile(String uuid) {
        FileUploadHandler newHandler = null;
        try {
            FileBase file = (FileBase)StructrApp.getInstance((SecurityContext)this.securityContext).getNodeById(uuid);
            if (file != null) {
                newHandler = new FileUploadHandler(file);
            }
        }
        catch (FrameworkException ex) {
            logger.warn("File not found with id " + uuid, (Throwable)ex);
        }
        return newHandler;
    }

    public void handleFileChunk(String uuid, int sequenceNumber, int chunkSize, byte[] data, int chunks) throws IOException {
        FileUploadHandler upload = this.uploads.get(uuid);
        if (upload == null) {
            upload = this.handleExistingFile(uuid);
        }
        if (upload != null) {
            upload.handleChunk(sequenceNumber, chunkSize, data, chunks);
        }
    }

    private void authenticate(String sessionId) {
        Principal user = AuthHelper.getPrincipalForSessionId(sessionId);
        if (user != null) {
            try {
                boolean sessionValid;
                boolean bl = sessionValid = !SessionHelper.isSessionTimedOut(SessionHelper.getSessionBySessionId(sessionId));
                if (sessionValid) {
                    this.setAuthenticated(sessionId, user);
                } else {
                    logger.warn("Session {} timed out - last accessed by {} ({})", new Object[]{sessionId, user.getName(), user.getUuid()});
                    SessionHelper.clearSession(sessionId);
                    SessionHelper.invalidateSession(SessionHelper.getSessionBySessionId(sessionId));
                    AuthHelper.sendLogoutNotification(user);
                    this.invalidateConsole();
                    this.timedOut = true;
                }
            }
            catch (FrameworkException ex) {
                logger.warn("FXE", (Throwable)ex);
            }
        }
    }

    public static void addCommand(Class command) {
        try {
            AbstractCommand msg = (AbstractCommand)command.newInstance();
            commandSet.put(msg.getCommand(), command);
        }
        catch (Throwable t) {
            logger.error("Unable to add command {}", (Object)command.getName());
        }
    }

    public Session getSession() {
        return this.session;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public Principal getCurrentUser() {
        return this.securityContext == null ? null : this.securityContext.getUser(false);
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public boolean isAuthenticated() {
        Principal user = this.getCurrentUser();
        return this.timedOut == false && user != null && (this.isPrivilegedUser(user) || this.isFrontendWebsocketAccessEnabled());
    }

    public boolean isPrivilegedUser(Principal user) {
        return user != null && ((Boolean)user.getProperty((PropertyKey)Principal.isAdmin) != false || (Boolean)user.getProperty(User.backendUser) != false);
    }

    public boolean isFrontendWebsocketAccessEnabled() {
        return (Boolean)Settings.WebsocketFrontendAccess.getValue();
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void invalidateConsole() {
        this.console = null;
    }

    public Console getConsole() {
        if (this.securityContext != null) {
            if (this.console != null) {
                return this.console;
            }
            this.console = new Console(this.securityContext, null);
            return this.console;
        }
        return null;
    }

    public void setAuthenticated(String sessionId, Principal user) {
        this.securityContext = SecurityContext.getInstance((Principal)user, (AccessMode)AccessMode.Backend);
        this.securityContext.setSessionId(sessionId);
        this.timedOut = false;
    }

    public void onWebSocketBinary(byte[] bytes, int i, int i1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void onWebSocketError(Throwable t) {
        logger.debug("Error in StructrWebSocket occured", t);
    }
}

