/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.Group;
import org.structr.core.entity.Principal;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class AppendUserCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)AppendUserCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String id = webSocketData.getId();
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String parentId = (String)nodeData.get("parentId");
        if (id == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append node, no id is given").build(), true);
            return;
        }
        if (parentId == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot add node without parentId").build(), true);
            return;
        }
        AbstractNode parentNode = this.getNode(parentId);
        if (parentNode == null) {
            this.getWebSocket().send(MessageBuilder.status().code(404).message("Parent node not found").build(), true);
            return;
        }
        if (parentNode instanceof Group) {
            Group group = (Group)parentNode;
            Principal user = (Principal)this.getNode(id);
            if (user != null) {
                try {
                    group.addMember(user);
                }
                catch (FrameworkException ex) {
                    logger.error("", (Throwable)ex);
                    this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot append file").build(), true);
                }
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Parent node is not instance of Folder").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "APPEND_USER";
    }

    static {
        StructrWebSocket.addCommand(AppendUserCommand.class);
    }
}

