/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.Page;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;
import org.w3c.dom.DOMException;

public class CloneComponentCommand
extends AbstractCommand {
    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String id = webSocketData.getId();
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String parentId = (String)nodeData.get("parentId");
        if (id == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot clone component, no id is given").build(), true);
            return;
        }
        if (parentId == null) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot clone component node without parentId").build(), true);
            return;
        }
        DOMNode parentNode = (DOMNode)this.getNode(parentId);
        if (parentNode == null) {
            this.getWebSocket().send(MessageBuilder.status().code(404).message("Parent node not found").build(), true);
            return;
        }
        DOMNode node = this.getDOMNode(id);
        try {
            this.cloneComponent(node, parentNode);
        }
        catch (FrameworkException | DOMException ex) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message(ex.getMessage()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "CLONE_COMPONENT";
    }

    public DOMNode cloneComponent(DOMNode node, DOMNode parentNode) throws FrameworkException {
        DOMNode clonedNode = (DOMNode)node.cloneNode(false);
        parentNode.appendChild(clonedNode);
        PropertyMap changedProperties = new PropertyMap();
        changedProperties.put(DOMNode.sharedComponent, (Object)node);
        changedProperties.put(DOMNode.ownerDocument, (Object)(parentNode instanceof Page ? (Page)parentNode : (Page)parentNode.getProperty((PropertyKey)DOMNode.ownerDocument)));
        clonedNode.setProperties(clonedNode.getSecurityContext(), changedProperties);
        return clonedNode;
    }

    static {
        StructrWebSocket.addCommand(CloneComponentCommand.class);
    }
}

