/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.web.entity.dom.Page;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class CreateSimplePage
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)CreateSimplePage.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        String pageName = (String)webSocketData.getNodeData().get(Page.name.dbName());
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        try {
            Page page = Page.createSimplePage(securityContext, pageName);
            TransactionCommand.registerNodeCallback((NodeInterface)page, (String)this.callback);
        }
        catch (FrameworkException fex) {
            logger.warn("Could not create node.", (Throwable)fex);
            this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.toString()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "CREATE_SIMPLE_PAGE";
    }

    static {
        StructrWebSocket.addCommand(CreateSimplePage.class);
    }
}

