/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.PropertyKey;
import org.structr.web.entity.AbstractFile;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class FindDuplicateFilesCommand
extends AbstractCommand {
    protected static final Logger logger = LoggerFactory.getLogger((String)FindDuplicateFilesCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        Query query = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery(AbstractFile.class).sort(AbstractFile.path);
        try {
            AbstractFile lastFile = null;
            String lastFilepath = null;
            boolean lastWasDupe = false;
            ArrayList<AbstractFile> filesWithSamePath = new ArrayList<AbstractFile>();
            for (AbstractNode node : query.getAsList()) {
                try {
                    AbstractFile file = (AbstractFile)node;
                    String currentFilepath = (String)file.getProperty((PropertyKey)AbstractFile.path);
                    if (lastFile != null) {
                        if (currentFilepath.equals(lastFilepath)) {
                            if (!lastWasDupe) {
                                filesWithSamePath.add(lastFile);
                            }
                            filesWithSamePath.add(file);
                            lastWasDupe = true;
                        } else {
                            lastWasDupe = false;
                        }
                    }
                    lastFilepath = currentFilepath;
                    lastFile = file;
                }
                catch (ClassCastException cce) {
                    logger.warn("Tried casting node '{}' of type '{}' to AbstractFile. Most likely a node type inheriting from File was deleted and an instance remains. Please delete this node or change its type.", (Object)node.getUuid(), (Object)node.getType());
                }
            }
            webSocketData.setResult(filesWithSamePath);
            webSocketData.setRawResultCount(filesWithSamePath.size());
            this.getWebSocket().send(webSocketData, true);
        }
        catch (FrameworkException fex) {
            logger.warn("Exception occured", (Throwable)fex);
            this.getWebSocket().send(MessageBuilder.status().code(fex.getStatus()).message(fex.getMessage()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "FIND_DUPLICATES";
    }

    static {
        StructrWebSocket.addCommand(FindDuplicateFilesCommand.class);
    }
}

