/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Result;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.CreateRelationshipCommand;
import org.structr.core.graph.NodeInterface;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.dom.DOMNode;
import org.structr.web.entity.dom.ShadowDocument;
import org.structr.web.entity.relation.Sync;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.command.CreateComponentCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class FixComponentsCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)FixComponentsCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        try {
            this.fixLostComponents();
        }
        catch (FrameworkException ex) {
            this.getWebSocket().send(MessageBuilder.status().code(422).message(ex.getMessage()).build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "FIX_LOST_COMPONENTS";
    }

    private void fixLostComponents() throws FrameworkException {
        ShadowDocument hiddenDoc = CreateComponentCommand.getOrCreateHiddenDocument();
        SecurityContext securityContext = SecurityContext.getSuperUserInstance();
        Result result = StructrApp.getInstance((SecurityContext)securityContext).nodeQuery(DOMNode.class).getResult();
        CreateRelationshipCommand createRel = (CreateRelationshipCommand)StructrApp.getInstance((SecurityContext)securityContext).command(CreateRelationshipCommand.class);
        for (DOMNode node : result.getResults()) {
            if (!node.hasChildNodes() || !node.hasIncomingRelationships(Sync.class) && !node.hasRelationship(Sync.class) || hiddenDoc.equals(node.getOwnerDocument())) continue;
            try {
                DOMNode clonedNode = (DOMNode)node.cloneNode(false);
                this.moveChildNodes(node, clonedNode);
                clonedNode.setProperties(securityContext, new PropertyMap(DOMNode.ownerDocument, (Object)hiddenDoc));
                createRel.execute((NodeInterface)node, (NodeInterface)clonedNode, Sync.class);
                createRel.execute((NodeInterface)clonedNode, (NodeInterface)node, Sync.class);
            }
            catch (Exception ex) {
                logger.error("Could not fix component " + node, (Throwable)ex);
            }
        }
    }

    static {
        StructrWebSocket.addCommand(FixComponentsCommand.class);
    }
}

