/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.WebSocketMessage;

public class GetPropertiesCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)GetPropertiesCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        String properties = (String)webSocketData.getNodeData().get("properties");
        if (properties != null) {
            securityContext.setCustomView(StringUtils.split((String)properties, (String)","));
        }
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        try {
            GraphObject graphObject = app.get(webSocketData.getId());
            webSocketData.setResult(Arrays.asList(graphObject));
            this.getWebSocket().send(webSocketData, true);
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to get graph object", (Throwable)fex);
        }
    }

    @Override
    public String getCommand() {
        return "GET_PROPERTIES";
    }

    static {
        StructrWebSocket.addCommand(GetPropertiesCommand.class);
    }
}

