/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.core.entity.AbstractRelationship;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.WebSocketMessage;

public class GetRelationshipCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)GetRelationshipCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        AbstractRelationship rel = this.getRelationship(webSocketData.getId());
        if (rel != null) {
            webSocketData.setResult(Arrays.asList(rel));
            this.getWebSocket().send(webSocketData, true);
        } else {
            logger.warn("Relationship not found for id {}!", (Object)webSocketData.getId());
        }
    }

    @Override
    public String getCommand() {
        return "GET_RELATIONSHIP";
    }

    static {
        StructrWebSocket.addCommand(GetRelationshipCommand.class);
    }
}

