/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.core.entity.Principal;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.property.PropertyMap;
import org.structr.web.entity.User;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class SaveLocalStorageCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)SaveLocalStorageCommand.class.getName());

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        Map<String, Object> nodeData = webSocketData.getNodeData();
        String localStorageString = (String)nodeData.get("localStorageString");
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        if (StringUtils.isNotBlank((String)localStorageString)) {
            try {
                Principal me = securityContext.getUser(false);
                me.setProperties(securityContext, new PropertyMap(User.localStorage, (Object)localStorageString));
                TransactionCommand.registerNodeCallback((NodeInterface)me, (String)this.callback);
            }
            catch (Throwable t) {
                logger.warn("Error saving localstorage", t);
                this.getWebSocket().send(MessageBuilder.status().code(422).message(t.toString()).build(), true);
            }
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Cannot save localStorage").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "SAVE_LOCAL_STORAGE";
    }

    static {
        StructrWebSocket.addCommand(SaveLocalStorageCommand.class);
    }
}

