/*
 * Decompiled with CFR 0.152.
 */
package org.structr.websocket.command;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObjectMap;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.Property;
import org.structr.rest.maintenance.SnapshotCommand;
import org.structr.websocket.StructrWebSocket;
import org.structr.websocket.command.AbstractCommand;
import org.structr.websocket.message.MessageBuilder;
import org.structr.websocket.message.WebSocketMessage;

public class SnapshotsCommand
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)SnapshotsCommand.class.getName());
    private static final Property<List<String>> snapshotsProperty = new GenericProperty("snapshots");
    private static final Property<String> statusProperty = new GenericProperty("status");

    @Override
    public void processMessage(WebSocketMessage webSocketData) {
        SecurityContext securityContext = this.getWebSocket().getSecurityContext();
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        Map<String, Object> data = webSocketData.getNodeData();
        String mode = (String)data.get("mode");
        String name = (String)data.get("name");
        String typesString = (String)data.get("types");
        List<String> types = typesString != null ? Arrays.asList(StringUtils.split((String)typesString, (String)",")) : null;
        if (mode != null) {
            LinkedList<GraphObjectMap> result = new LinkedList<GraphObjectMap>();
            switch (mode) {
                case "list": {
                    List<String> snapshots = SnapshotCommand.listSnapshots();
                    if (snapshots == null) break;
                    GraphObjectMap snapshotContainer = new GraphObjectMap();
                    snapshotContainer.put(snapshotsProperty, snapshots);
                    result.add(snapshotContainer);
                    break;
                }
                case "get": {
                    Path snapshotFile = Paths.get(SnapshotCommand.getSnapshotsPath() + name, new String[0]);
                    if (!Files.exists(snapshotFile, new LinkOption[0])) break;
                    try {
                        String content = new String(Files.readAllBytes(snapshotFile));
                        this.getWebSocket().send(MessageBuilder.finished().callback(this.callback).data("schemaJson", content).build(), true);
                        return;
                    }
                    catch (IOException ex) {
                        LoggerFactory.getLogger((String)SnapshotsCommand.class.getName()).error("", (Throwable)ex);
                        break;
                    }
                }
                default: {
                    GraphObjectMap msg = new GraphObjectMap();
                    result.add(msg);
                    try {
                        ((SnapshotCommand)app.command(SnapshotCommand.class)).execute(mode, name, types);
                        msg.put(statusProperty, (Object)"success");
                        break;
                    }
                    catch (Throwable t) {
                        logger.warn("", t);
                        msg.put(statusProperty, (Object)t.getMessage());
                    }
                }
            }
            webSocketData.setResult(result);
            webSocketData.setRawResultCount(1);
            this.getWebSocket().send(webSocketData, true);
        } else {
            this.getWebSocket().send(MessageBuilder.status().code(422).message("Mode must be one of list, export, add or restore.").build(), true);
        }
    }

    @Override
    public String getCommand() {
        return "SNAPSHOTS";
    }

    static {
        StructrWebSocket.addCommand(SnapshotsCommand.class);
    }
}

