/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.subtree;

import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.subtree.Subentry;
import org.apache.directory.api.ldap.model.subtree.SubtreeSpecification;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.subtree.SubentryCache;
import org.apache.directory.server.core.api.subtree.SubtreeEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubentryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SubentryUtils.class);
    protected DirectoryService directoryService;
    protected SchemaManager schemaManager;

    public SubentryUtils(DirectoryService directoryService) {
        this.directoryService = directoryService;
        this.schemaManager = directoryService.getSchemaManager();
    }

    public Entry getSubentryAttributes(Dn dn, Entry entryAttrs) throws LdapException {
        DefaultEntry subentryAttrs = new DefaultEntry(this.schemaManager, dn);
        SubentryCache subentryCache = this.directoryService.getSubentryCache();
        SubtreeEvaluator evaluator = this.directoryService.getEvaluator();
        for (Dn subentryDn : subentryCache) {
            Attribute operational;
            Dn apDn = subentryDn.getParent();
            Subentry subentry = subentryCache.getSubentry(subentryDn);
            SubtreeSpecification ss = subentry.getSubtreeSpecification();
            if (!evaluator.evaluate(ss, apDn, dn, entryAttrs)) continue;
            if (subentry.isAccessControlAdminRole()) {
                operational = subentryAttrs.get(this.directoryService.getAtProvider().getAccessControlSubentries());
                if (operational == null) {
                    operational = new DefaultAttribute(this.directoryService.getAtProvider().getAccessControlSubentries());
                    subentryAttrs.put(new Attribute[]{operational});
                }
                operational.add(new String[]{subentryDn.getNormName()});
            }
            if (subentry.isSchemaAdminRole()) {
                operational = subentryAttrs.get(this.directoryService.getAtProvider().getSubschemaSubentry());
                if (operational == null) {
                    operational = new DefaultAttribute(this.directoryService.getAtProvider().getSubschemaSubentry());
                    subentryAttrs.put(new Attribute[]{operational});
                }
                operational.add(new String[]{subentryDn.getNormName()});
            }
            if (subentry.isCollectiveAdminRole()) {
                operational = subentryAttrs.get(this.directoryService.getAtProvider().getCollectiveAttributeSubentries());
                if (operational == null) {
                    operational = new DefaultAttribute(this.directoryService.getAtProvider().getCollectiveAttributeSubentries());
                    subentryAttrs.put(new Attribute[]{operational});
                }
                operational.add(new String[]{subentryDn.getNormName()});
            }
            if (!subentry.isTriggersAdminRole()) continue;
            operational = subentryAttrs.get(this.directoryService.getAtProvider().getTriggerExecutionSubentries());
            if (operational == null) {
                operational = new DefaultAttribute(this.directoryService.getAtProvider().getTriggerExecutionSubentries());
                subentryAttrs.put(new Attribute[]{operational});
            }
            operational.add(new String[]{subentryDn.getNormName()});
        }
        return subentryAttrs;
    }
}

