/*
 * Decompiled with CFR 0.152.
 */
package org.structr.api.config;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.config.Setting;
import org.structr.api.config.SettingsGroup;
import org.structr.api.util.html.Attr;
import org.structr.api.util.html.Tag;

public class IntegerSetting
extends Setting<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(IntegerSetting.class);

    public IntegerSetting(SettingsGroup settingsGroup, String string) {
        this(settingsGroup, string, null);
    }

    public IntegerSetting(SettingsGroup settingsGroup, String string, Integer n) {
        this(settingsGroup, (String)null, string, n);
    }

    public IntegerSetting(SettingsGroup settingsGroup, String string, String string2, Integer n) {
        super(settingsGroup, string, string2, n);
    }

    @Override
    public void render(Tag tag) {
        Tag tag2 = tag.block("div").css("form-group");
        tag2.block("label").text(this.getKey());
        Tag tag3 = tag2.empty("input").attr(new Attr("type", "text"), new Attr("name", this.getKey()));
        Integer n = (Integer)this.getValue();
        if (n != null) {
            tag3.attr(new Attr("value", n));
        }
        this.renderResetButton(tag2);
    }

    @Override
    public void fromString(String string) {
        if (string == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)string)) {
            try {
                this.setValue(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                logger.warn("Invalid value for setting {0}: {1}, ignoring.", new Object[]{this.getKey(), string});
            }
        } else {
            this.setValue(-1);
        }
    }
}

