/*
 * Decompiled with CFR 0.152.
 */
package org.structr.api.config;

import org.structr.api.config.Settings;
import org.structr.api.config.SettingsGroup;
import org.structr.api.util.html.Attr;
import org.structr.api.util.html.Tag;

public abstract class Setting<T> {
    private SettingsGroup group = null;
    private boolean isDynamic = false;
    private T defaultValue = null;
    private String category = null;
    private String key = null;
    private T value = null;
    private String comment = null;

    public abstract void render(Tag var1);

    public abstract void fromString(String var1);

    public Setting(SettingsGroup settingsGroup, String string, String string2, T t) {
        this(settingsGroup, string, string2, t, null);
    }

    public Setting(SettingsGroup settingsGroup, String string, String string2, T t, String string3) {
        this.key = string2;
        this.value = t;
        this.category = string;
        this.group = settingsGroup;
        this.defaultValue = t;
        this.comment = string3;
        settingsGroup.registerSetting(this);
        Settings.registerSetting(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getCategory() {
        return this.category;
    }

    public String getComment() {
        return this.comment;
    }

    public T getValue() {
        return this.value;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue(T t) {
        if (this.value == null) {
            return t;
        }
        return this.value;
    }

    public void setValue(T t) {
        this.value = t;
    }

    public boolean isModified() {
        return this.defaultValue != null && !this.defaultValue.equals(this.value) || this.defaultValue == null && this.value != null;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public void setIsDynamic(boolean bl) {
        this.isDynamic = bl;
    }

    public void unregister() {
        this.group.unregisterSetting(this);
        Settings.unregisterSetting(this);
    }

    protected void renderResetButton(Tag tag) {
        if (this.isModified()) {
            Tag tag2 = tag.block("i").css("sprite sprite-cancel").attr(new Attr("onclick", "javascript:resetToDefault('" + this.getKey() + "');"));
            if (this.isDynamic()) {
                tag2.attr(new Attr("title", "Remove"));
            } else {
                tag2.attr(new Attr("title", "Reset to default"));
            }
        }
    }
}

