/*
 * Decompiled with CFR 0.152.
 */
package org.structr.api.util.html;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.structr.api.util.html.Attr;
import org.structr.api.util.html.Block;
import org.structr.api.util.html.Empty;
import org.structr.api.util.html.Inline;
import org.structr.api.util.html.attr.Context;
import org.structr.api.util.html.attr.Css;
import org.structr.api.util.html.attr.Id;

public abstract class Tag {
    private final List<Attr> attrs = new LinkedList<Attr>();
    private final List<Tag> children = new LinkedList<Tag>();
    private boolean empty = false;
    private boolean newline = false;
    private String text = null;
    private String tag = null;
    private String indent = "";
    private Tag parent = null;

    Tag(Tag tag, String string) {
        this(tag, string, false);
    }

    Tag(Tag tag, String string, boolean bl) {
        this(tag, string, bl, true);
    }

    Tag(Tag tag, String string, boolean bl, boolean bl2) {
        this.parent = tag;
        this.tag = string;
        this.empty = bl;
        this.newline = StringUtils.isNotEmpty((CharSequence)this.indent) && bl2;
    }

    public Tag block(String string) {
        Block block = new Block(this, string);
        this.add(block);
        return block;
    }

    public Tag inline(String string) {
        Inline inline = new Inline(this, string);
        this.add(inline);
        return inline;
    }

    public Tag empty(String string) {
        Empty empty = new Empty(this, string);
        this.add(empty);
        return empty;
    }

    public Tag text(Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            stringBuilder.append(object);
        }
        this.text = stringBuilder.toString();
        return this;
    }

    public void setIndent(String string) {
        this.indent = string;
    }

    public List<Tag> getChildren() {
        return this.children;
    }

    public Tag add(Tag tag) {
        this.children.add(tag);
        return this;
    }

    public Tag attr(Attr ... attrArray) {
        this.attrs.addAll(Arrays.asList(attrArray));
        return this;
    }

    public Tag id(String string) {
        this.attr(new Id(string));
        return this;
    }

    public Tag css(String string) {
        this.attr(new Css(string));
        return this;
    }

    public Tag parent() {
        return this.parent;
    }

    public void appendComma() {
        if (!this.children.isEmpty()) {
            this.children.get(this.children.size() - 1).appendComma();
        } else if (this.text != null) {
            this.text = this.text.concat(",");
        }
    }

    protected void render(PrintWriter printWriter, int n) throws IOException {
        Tag.beginTag(printWriter, this.tag, this.empty, this.attrs, n, this.indent);
        if (!this.empty) {
            if (this.text != null) {
                printWriter.print(this.text);
            }
            if (this.newline) {
                printWriter.println();
            }
            for (Tag tag : this.children) {
                tag.render(printWriter, n + 1);
            }
            Tag.endTag(printWriter, this.tag, this.newline, n, this.indent);
        }
    }

    protected static void beginTag(PrintWriter printWriter, String string, boolean bl, List<Attr> list, int n, String string2) throws IOException {
        Tag.beginTag(printWriter, string, bl, false, list, n, string2);
    }

    protected static void beginTag(PrintWriter printWriter, String string, boolean bl, boolean bl2, List<Attr> list, int n, String string2) throws IOException {
        Context context = new Context(n);
        printWriter.flush();
        for (int i = 0; i < n; ++i) {
            printWriter.print(string2);
        }
        printWriter.print("<" + string);
        for (Attr attr : list) {
            String string3 = attr.format(context);
            if (string3.length() <= 0) continue;
            printWriter.print(" " + string3);
        }
        if (bl) {
            if (bl2) {
                printWriter.println("/>");
            } else {
                printWriter.println(">");
            }
        } else if (bl2) {
            printWriter.print("/>");
        } else {
            printWriter.print(">");
        }
    }

    protected static void endTag(PrintWriter printWriter, String string, boolean bl, int n, String string2) throws IOException {
        printWriter.flush();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                printWriter.print(string2);
            }
        }
        printWriter.println("</" + string + ">");
    }
}

