/*
 * Decompiled with CFR 0.152.
 */
package org.structr.jar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.x509.X509V3CertificateGenerator;
import org.structr.common.error.FrameworkException;
import org.structr.jar.NameAndContent;
import org.structr.schema.action.ActionContext;
import org.structr.web.function.UiFunction;

public class CreateJarFileFunction
extends UiFunction {
    public String getName() {
        return "create_jar_file";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object apply(ActionContext actionContext, Object object, Object[] objectArray) throws FrameworkException {
        if (!this.arrayHasMinLengthAndAllElementsNotNull(objectArray, 2)) {
            this.logParameterError(object, objectArray, actionContext.isJavaScriptContext());
            return "";
        }
        if (!(objectArray[0] instanceof OutputStream)) {
            logger.warn("First parameter of create_jar_file() must be an output stream. Parameters: {}", (Object)this.getParametersAsString(objectArray));
            return "First parameter of create_jar_file() must be an output stream.";
        }
        try {
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)objectArray[0]);
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            PrivateKey privateKey = this.getOrCreatePrivateKey("RSA", "SHA1PRNG", "SHA1withRSA");
            X509Certificate x509Certificate = this.getOrCreateCertificate("RSA", "SHA1PRNG", "SHA1withRSA");
            System.out.println("This is the fingerprint of the keystore: " + this.hex(x509Certificate));
            jarOutputStream.setLevel(9);
            attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
            for (Object object2 : objectArray) {
                if (object2 == null || !(object2 instanceof NameAndContent)) continue;
                NameAndContent nameAndContent = (NameAndContent)object2;
                JarEntry jarEntry = new JarEntry(nameAndContent.getName());
                byte[] byArray = nameAndContent.getContent().getBytes("utf-8");
                jarEntry.setTime(System.currentTimeMillis());
                jarOutputStream.putNextEntry(jarEntry);
                jarOutputStream.write(byArray);
                jarOutputStream.closeEntry();
                jarOutputStream.flush();
                messageDigest.update(byArray);
                Attributes attributes2 = manifest.getAttributes(jarEntry.getName());
                if (attributes2 == null) {
                    attributes2 = new Attributes();
                    manifest.getEntries().put(jarEntry.getName(), attributes2);
                }
                attributes2.putValue("SHA1-Digest", new String(Base64.encode((byte[])messageDigest.digest()), "ASCII"));
            }
            jarOutputStream.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
            manifest.write(jarOutputStream);
            byte[] byArray = this.getSignatureForManifest(manifest, "SHA1");
            jarOutputStream.putNextEntry(new JarEntry("META-INF/CERT.SF"));
            jarOutputStream.write(byArray);
            if (privateKey != null && x509Certificate != null) {
                jarOutputStream.putNextEntry(new JarEntry("META-INF/CERT." + privateKey.getAlgorithm()));
                this.writeSignatureBlock(jarOutputStream, "SHA1", (CMSTypedData)new CMSProcessableByteArray(byArray), x509Certificate, privateKey);
            } else {
                System.out.println("No certificate / key found, signinig disabled.");
            }
            jarOutputStream.flush();
            jarOutputStream.finish();
            return "";
        }
        catch (Throwable throwable) {
            this.logException(object, throwable, objectArray);
            return "";
        }
    }

    public String usage(boolean bl) {
        return "create_jar_file()";
    }

    public String shortDescription() {
        return "Creates a signed JAR file from the given contents.";
    }

    private byte[] getSignatureForManifest(Manifest manifest, String string) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Manifest manifest2 = new Manifest();
        Attributes attributes = manifest2.getMainAttributes();
        MessageDigest messageDigest = MessageDigest.getInstance(string);
        PrintStream printStream = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), messageDigest), true, "UTF-8");
        attributes.putValue("Signature-Version", "1.0");
        manifest.write(printStream);
        printStream.flush();
        attributes.putValue(string + "-Digest-Manifest", new String(Base64.encode((byte[])messageDigest.digest()), "ASCII"));
        Map<String, Attributes> map = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : map.entrySet()) {
            printStream.print("Name: " + entry.getKey() + "\r\n");
            for (Map.Entry<Object, Object> entry2 : entry.getValue().entrySet()) {
                printStream.print(entry2.getKey() + ": " + entry2.getValue() + "\r\n");
            }
            printStream.print("\r\n");
            printStream.flush();
            Attributes attributes2 = new Attributes();
            attributes2.putValue(string + "-Digest", new String(Base64.encode((byte[])messageDigest.digest()), "ASCII"));
            manifest2.getEntries().put(entry.getKey(), attributes2);
        }
        manifest2.write(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeSignatureBlock(JarOutputStream jarOutputStream, String string, CMSTypedData cMSTypedData, X509Certificate x509Certificate, PrivateKey privateKey) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate);
        JcaCertStore jcaCertStore = new JcaCertStore(arrayList);
        CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder(string + "with" + privateKey.getAlgorithm()).build(privateKey);
        SignerInfoGenerator signerInfoGenerator = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).setDirectSignature(true).build(contentSigner, x509Certificate);
        cMSSignedDataGenerator.addSignerInfoGenerator(signerInfoGenerator);
        cMSSignedDataGenerator.addCertificates((Store)jcaCertStore);
        CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSTypedData, false);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(cMSSignedData.getEncoded());
        DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)jarOutputStream);
        ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
        dEROutputStream.writeObject((ASN1Encodable)aSN1Primitive);
    }

    private PrivateKey getOrCreatePrivateKey(String string, String string2, String string3) {
        KeyStore keyStore = this.getOrCreateKeystore(string, string2, string3);
        if (keyStore != null) {
            try {
                return (PrivateKey)keyStore.getKey("priv", "test".toCharArray());
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
        return null;
    }

    private X509Certificate getOrCreateCertificate(String string, String string2, String string3) {
        KeyStore keyStore = this.getOrCreateKeystore(string, string2, string3);
        if (keyStore != null) {
            try {
                return (X509Certificate)keyStore.getCertificate("cert");
            }
            catch (Throwable throwable) {
                logger.warn("", throwable);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore getOrCreateKeystore(String string, String string2, String string3) {
        File file = new File("test.keystore");
        if (file.exists()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                KeyStore keyStore3 = KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore3.load(fileInputStream, "test".toCharArray());
                KeyStore keyStore2 = keyStore3;
                return keyStore2;
            }
            catch (Throwable throwable7) {
                logger.warn("", throwable7);
                return null;
            }
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            KeyStore keyStore4 = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore4.load(null, "test".toCharArray());
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(string);
            keyPairGenerator.initialize(1024, SecureRandom.getInstance(string2));
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
            Date date = simpleDateFormat.parse("01.01.2015");
            Date date2 = simpleDateFormat.parse("01.01.2017");
            BigInteger bigInteger = BigInteger.valueOf(1234L);
            X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
            X500Principal x500Principal = new X500Principal("CN=Test CA Certificate");
            x509V3CertificateGenerator.setSerialNumber(bigInteger);
            x509V3CertificateGenerator.setIssuerDN(x500Principal);
            x509V3CertificateGenerator.setNotBefore(date);
            x509V3CertificateGenerator.setNotAfter(date2);
            x509V3CertificateGenerator.setSubjectDN(x500Principal);
            x509V3CertificateGenerator.setPublicKey(keyPair.getPublic());
            x509V3CertificateGenerator.setSignatureAlgorithm(string3);
            X509Certificate x509Certificate = x509V3CertificateGenerator.generate(keyPair.getPrivate());
            keyStore4.setCertificateEntry("cert", x509Certificate);
            keyStore4.setKeyEntry("priv", keyPair.getPrivate(), "test".toCharArray(), new Certificate[]{x509Certificate});
            keyStore4.store(fileOutputStream, "test".toCharArray());
            fileOutputStream.flush();
            KeyStore keyStore = keyStore4;
            return keyStore;
        }
        catch (Throwable throwable12) {
            logger.warn("", throwable12);
        }
        return null;
    }

    public String hex(Certificate certificate) {
        byte[] byArray;
        try {
            byArray = certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            byArray = new byte[]{};
        }
        return this.hex(byArray);
    }

    public String hex(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            int n = by >> 4 & 0xF;
            byArray2[i * 2] = (byte)(n >= 10 ? 97 + n - 10 : 48 + n);
            n = by & 0xF;
            byArray2[i * 2 + 1] = (byte)(n >= 10 ? 97 + n - 10 : 48 + n);
        }
        return new String(byArray2);
    }
}

