/*
 * Decompiled with CFR 0.152.
 */
package org.structr.jar;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.DigestOutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedJarBuilder {
    private static final Logger logger = LoggerFactory.getLogger((String)SignedJarBuilder.class.getName());
    private final byte[] buffer = new byte[4096];
    private JarOutputStream jarOutputStream = null;
    private PrivateKey privateKey = null;
    private X509Certificate certificate = null;
    private Manifest manifest = null;
    private MessageDigest messageDigest = null;

    public SignedJarBuilder(OutputStream outputStream, PrivateKey privateKey, X509Certificate x509Certificate) throws IOException, NoSuchAlgorithmException {
        this.jarOutputStream = new JarOutputStream(new BufferedOutputStream(outputStream));
        this.privateKey = privateKey;
        this.certificate = x509Certificate;
        this.jarOutputStream.setLevel(9);
        if (this.privateKey != null && x509Certificate != null) {
            this.manifest = new Manifest();
            Attributes attributes = this.manifest.getMainAttributes();
            attributes.putValue("Manifest-Version", "1.0");
            this.messageDigest = MessageDigest.getInstance("SHA1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFile(File file, String string) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            JarEntry jarEntry = new JarEntry(string);
            jarEntry.setTime(file.lastModified());
            this.writeEntry(fileInputStream, jarEntry);
        }
    }

    public void close() throws IOException {
        if (this.manifest != null) {
            this.jarOutputStream.putNextEntry(new JarEntry("META-INF/MANIFEST.MF"));
            this.manifest.write(this.jarOutputStream);
            try {
                byte[] byArray = this.getSignature(this.manifest);
                this.jarOutputStream.putNextEntry(new JarEntry("META-INF/CERT.SF"));
                this.jarOutputStream.write(byArray);
                this.jarOutputStream.putNextEntry(new JarEntry("META-INF/CERT." + this.privateKey.getAlgorithm()));
                this.writeSignatureBlock(this.jarOutputStream, (CMSTypedData)new CMSProcessableByteArray(byArray), this.certificate, this.privateKey);
            }
            catch (Exception exception) {
                logger.warn("", (Throwable)exception);
            }
        }
        this.jarOutputStream.close();
        this.jarOutputStream = null;
    }

    public void cleanUp() {
        if (this.jarOutputStream != null) {
            try {
                this.jarOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void writeEntry(InputStream inputStream, JarEntry jarEntry) throws IOException {
        int n;
        this.jarOutputStream.putNextEntry(jarEntry);
        while ((n = inputStream.read(this.buffer)) != -1) {
            this.jarOutputStream.write(this.buffer, 0, n);
            if (this.messageDigest == null) continue;
            this.messageDigest.update(this.buffer, 0, n);
        }
        this.jarOutputStream.closeEntry();
        if (this.manifest != null) {
            Attributes attributes = this.manifest.getAttributes(jarEntry.getName());
            if (attributes == null) {
                attributes = new Attributes();
                this.manifest.getEntries().put(jarEntry.getName(), attributes);
            }
            attributes.putValue("SHA1-Digest", new String(Base64.encode((byte[])this.messageDigest.digest()), "ASCII"));
        }
    }

    private byte[] getSignature(Manifest manifest) throws IOException, GeneralSecurityException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Manifest manifest2 = new Manifest();
        Attributes attributes = manifest2.getMainAttributes();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        PrintStream printStream = new PrintStream((OutputStream)new DigestOutputStream(new ByteArrayOutputStream(), messageDigest), true, "UTF-8");
        attributes.putValue("Signature-Version", "1.0");
        manifest.write(printStream);
        printStream.flush();
        attributes.putValue("SHA1-Digest-Manifest", new String(Base64.encode((byte[])messageDigest.digest()), "ASCII"));
        Map<String, Attributes> map = manifest.getEntries();
        for (Map.Entry<String, Attributes> entry : map.entrySet()) {
            printStream.print("Name: " + entry.getKey() + "\r\n");
            for (Map.Entry<Object, Object> entry2 : entry.getValue().entrySet()) {
                printStream.print(entry2.getKey() + ": " + entry2.getValue() + "\r\n");
            }
            printStream.print("\r\n");
            printStream.flush();
            Attributes attributes2 = new Attributes();
            attributes2.putValue("SHA1-Digest", new String(Base64.encode((byte[])messageDigest.digest()), "ASCII"));
            manifest2.getEntries().put(entry.getKey(), attributes2);
        }
        manifest2.write(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeSignatureBlock(JarOutputStream jarOutputStream, CMSTypedData cMSTypedData, X509Certificate x509Certificate, PrivateKey privateKey) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(x509Certificate);
        JcaCertStore jcaCertStore = new JcaCertStore(arrayList);
        CMSSignedDataGenerator cMSSignedDataGenerator = new CMSSignedDataGenerator();
        ContentSigner contentSigner = new JcaContentSignerBuilder("SHA1with" + privateKey.getAlgorithm()).build(privateKey);
        cMSSignedDataGenerator.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).setDirectSignature(true).build(contentSigner, x509Certificate));
        cMSSignedDataGenerator.addCertificates((Store)jcaCertStore);
        CMSSignedData cMSSignedData = cMSSignedDataGenerator.generate(cMSTypedData, false);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(cMSSignedData.getEncoded());
        DEROutputStream dEROutputStream = new DEROutputStream((OutputStream)jarOutputStream);
        dEROutputStream.writeObject((ASN1Encodable)aSN1InputStream.readObject());
    }
}

