/*
 * Decompiled with CFR 0.152.
 */
package org.structr.geo;

import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.CRS;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.error.FrameworkException;
import org.structr.schema.action.ActionContext;
import org.structr.schema.action.Function;

public class LatLonToUTMFunction
extends Function<Object, Object> {
    private static final String ERROR_MESSAGE = "Usage: ${latLonToUTM(latitude, longitude)}. Example: ${latLonToUTM(41.3445, 7.35)}";
    private static final Logger logger = LoggerFactory.getLogger((String)LatLonToUTMFunction.class.getName());
    private static final String UTMzdlChars = "CDEFGHJKLMNPQRSTUVWXX";

    public Object apply(ActionContext actionContext, Object object, Object[] objectArray) throws FrameworkException {
        if (this.arrayHasLengthAndAllElementsNotNull(objectArray, 2)) {
            Double d = this.getDoubleOrNull(objectArray[0]);
            Double d2 = this.getDoubleOrNull(objectArray[1]);
            if (d != null && d2 != null) {
                try {
                    StringBuilder stringBuilder = new StringBuilder("EPSG:32");
                    int n = this.getUTMZone(d, d2);
                    if (d < 0.0) {
                        stringBuilder.append("7");
                    } else {
                        stringBuilder.append("6");
                    }
                    if (n < 10) {
                        stringBuilder.append("0");
                    }
                    stringBuilder.append(n);
                    CoordinateReferenceSystem coordinateReferenceSystem = CRS.decode((String)"EPSG:4326");
                    CoordinateReferenceSystem coordinateReferenceSystem2 = CRS.decode((String)stringBuilder.toString());
                    MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)coordinateReferenceSystem, (CoordinateReferenceSystem)coordinateReferenceSystem2, (boolean)true);
                    DirectPosition2D directPosition2D = new DirectPosition2D(d.doubleValue(), d2.doubleValue());
                    DirectPosition directPosition = mathTransform.transform((DirectPosition)directPosition2D, null);
                    String string = coordinateReferenceSystem2.getName().getCode();
                    int n2 = string.lastIndexOf(" ") + 1;
                    String string2 = string.substring(n2, string.length() - 1);
                    String string3 = this.getLatitudeBand(d, d2);
                    StringBuilder stringBuilder2 = new StringBuilder();
                    stringBuilder2.append(string2);
                    stringBuilder2.append(string3);
                    stringBuilder2.append(" ");
                    stringBuilder2.append((int)Math.rint(directPosition.getOrdinate(0)));
                    stringBuilder2.append(" ");
                    stringBuilder2.append((int)Math.rint(directPosition.getOrdinate(1)));
                    return stringBuilder2.toString();
                }
                catch (Throwable throwable) {
                    logger.warn("", throwable);
                }
            } else {
                logger.warn("Invalid argument(s), cannot convert to double: {}, {}", new Object[]{objectArray[0], objectArray[1]});
            }
        }
        return this.usage(actionContext != null ? actionContext.isJavaScriptContext() : false);
    }

    public String usage(boolean bl) {
        return ERROR_MESSAGE;
    }

    public String shortDescription() {
        return "Converts the given latitude/longitude coordinates into an UTM string.";
    }

    public String getName() {
        return "lat_lon_to_utm";
    }

    private int getUTMZone(double d, double d2) {
        int n = Double.valueOf(Math.floor((d2 + 180.0) / 6.0)).intValue() + 1;
        if (d >= 56.0 && d < 64.0 && d2 >= 3.0 && d2 < 12.0) {
            n = 32;
        }
        if (d >= 72.0 && d < 84.0) {
            if (d2 >= 0.0 && d2 < 9.0) {
                n = 31;
            }
        } else if (d2 >= 9.0 && d2 < 21.0) {
            n = 33;
        } else if (d2 >= 21.0 && d2 < 33.0) {
            n = 35;
        } else if (d2 >= 33.0 && d2 < 42.0) {
            n = 37;
        }
        return n;
    }

    private String getLatitudeBand(double d, double d2) {
        if (d >= -80.0 && d <= 84.0) {
            double d3 = Math.floor((d + 80.0) / 8.0);
            int n = Double.valueOf(d3).intValue();
            return UTMzdlChars.substring(n, n + 1);
        }
        return null;
    }
}

