/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.maintenance;

import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.DatabaseService;
import org.structr.api.graph.Node;
import org.structr.api.graph.Relationship;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.NodeService;
import org.structr.core.graph.NodeServiceCommand;
import org.structr.core.graph.Tx;
import org.structr.rest.resource.MaintenanceParameterResource;

public class DeleteSpatialIndexCommand
extends NodeServiceCommand
implements MaintenanceCommand {
    private static final Logger logger = LoggerFactory.getLogger((String)DeleteSpatialIndexCommand.class.getName());

    public void execute(Map<String, Object> attributes) throws FrameworkException {
        DatabaseService graphDb = ((NodeService)StructrApp.getInstance().getService(NodeService.class)).getGraphDb();
        LinkedList<Node> toDelete = new LinkedList<Node>();
        for (Node node : graphDb.getAllNodes()) {
            try {
                if (!node.hasProperty("bbox") || !node.hasProperty("gtype") || !node.hasProperty("id") || !node.hasProperty("latitude") || !node.hasProperty("longitude")) continue;
                toDelete.add(node);
            }
            catch (Throwable throwable) {}
        }
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        try (Tx tx = app.tx();){
            for (Node node : toDelete) {
                logger.info("Deleting node {}", (Object)node);
                try {
                    for (Relationship rel : node.getRelationships()) {
                        rel.delete();
                    }
                    node.delete();
                }
                catch (Throwable t) {
                    logger.warn("", t);
                }
            }
            tx.success();
        }
    }

    public boolean requiresEnclosingTransaction() {
        return true;
    }

    public boolean requiresFlushingOfCaches() {
        return false;
    }

    static {
        MaintenanceParameterResource.registerMaintenanceCommand("deleteSpatialIndex", DeleteSpatialIndexCommand.class);
    }
}

