/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.graph.Direction;
import org.structr.api.util.Iterables;
import org.structr.common.PagingHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.PropertyKey;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.UuidResource;
import org.structr.rest.resource.WrappingResource;

public class RelationshipResource
extends WrappingResource {
    public static final String REQUEST_PARAMETER_FILTER_INTERNAL_RELATIONSHIP_TYPES = "domainOnly";
    private static final Logger logger = LoggerFactory.getLogger((String)RelationshipResource.class.getName());
    private Direction direction = null;

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) {
        this.securityContext = securityContext;
        if ("in".equals(part.toLowerCase())) {
            this.direction = Direction.INCOMING;
            return true;
        }
        if ("out".equals(part.toLowerCase())) {
            this.direction = Direction.OUTGOING;
            return true;
        }
        return false;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        List results = this.wrappedResource.doGet(null, false, Integer.MAX_VALUE, 1, null).getResults();
        App app = StructrApp.getInstance();
        if (results != null && !results.isEmpty()) {
            try {
                LinkedList<RelationshipInterface> resultList = new LinkedList<RelationshipInterface>();
                for (GraphObject obj : results) {
                    String filterInternal;
                    List relationships;
                    if (!(obj instanceof AbstractNode) || (relationships = Direction.INCOMING.equals((Object)this.direction) ? Iterables.toList((Iterable)((AbstractNode)obj).getIncomingRelationships()) : Iterables.toList((Iterable)((AbstractNode)obj).getOutgoingRelationships())) == null) continue;
                    boolean filterInternalRelationshipTypes = false;
                    if (this.securityContext != null && this.securityContext.getRequest() != null && (filterInternal = this.securityContext.getRequest().getParameter(REQUEST_PARAMETER_FILTER_INTERNAL_RELATIONSHIP_TYPES)) != null) {
                        filterInternalRelationshipTypes = "true".equals(filterInternal);
                    }
                    if (filterInternalRelationshipTypes) {
                        for (RelationshipInterface rel : relationships) {
                            if (rel.isInternal()) continue;
                            resultList.add(rel);
                        }
                        continue;
                    }
                    resultList.addAll(relationships);
                }
                int rawResultCount = resultList.size();
                return new Result(PagingHelper.subList(resultList, (int)pageSize, (int)page, (String)offsetId), Integer.valueOf(rawResultCount), true, false);
            }
            catch (Throwable t) {
                logger.warn("Exception while fetching relationships", t);
            }
        } else {
            logger.info("No results from parent..");
        }
        throw new IllegalPathException(this.getResourceSignature() + " can only be applied to a non-empty resource");
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        if (next instanceof UuidResource) {
            return next;
        }
        return super.tryCombineWith(next);
    }

    @Override
    public boolean isCollectionResource() {
        return true;
    }

    @Override
    public String getResourceSignature() {
        return this.wrappedResource.getResourceSignature();
    }
}

