/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Result;
import org.structr.core.property.PropertyKey;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalMethodException;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.SchemaResource;
import org.structr.rest.resource.TypeResource;
import org.structr.rest.resource.ViewFilterResource;
import org.structr.schema.SchemaHelper;

public class SchemaTypeResource
extends Resource {
    protected Class entityClass = null;
    private static String rawType = null;
    protected HttpServletRequest request = null;
    protected TypeResource typeResource = null;
    private String propertyView = null;

    public SchemaTypeResource(SecurityContext securityContext, TypeResource typeResource) {
        this.securityContext = securityContext;
        this.typeResource = typeResource;
        rawType = typeResource.getRawType();
    }

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) throws FrameworkException {
        return true;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        Class type = this.typeResource.getEntityClass();
        return SchemaTypeResource.getSchemaTypeResult(this.securityContext, type, this.propertyView);
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        throw new IllegalMethodException("POST not allowed on " + this.getResourceSignature());
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        if (next instanceof ViewFilterResource) {
            this.propertyView = ((ViewFilterResource)next).getPropertyView();
        }
        return this;
    }

    @Override
    public String getUriPart() {
        return rawType;
    }

    public String getRawType() {
        return rawType;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    @Override
    public String getResourceSignature() {
        return SchemaResource.UriPart._schema.name().concat("/").concat(SchemaHelper.normalizeEntityName((String)this.getUriPart()));
    }

    @Override
    public boolean isCollectionResource() {
        return true;
    }

    public static Result getSchemaTypeResult(SecurityContext securityContext, Class type, String propertyView) throws FrameworkException {
        List resultList = SchemaHelper.getSchemaTypeInfo((SecurityContext)securityContext, (String)rawType, (Class)type, (String)propertyView);
        return new Result(resultList, Integer.valueOf(resultList.size()), false, false);
    }
}

