/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.PagingHelper;
import org.structr.common.ResultTransformer;
import org.structr.common.SecurityContext;
import org.structr.common.error.EmptyPropertyToken;
import org.structr.common.error.ErrorBuffer;
import org.structr.common.error.ErrorToken;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.entity.Relation;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.search.SearchCommand;
import org.structr.core.graph.search.SearchNodeCommand;
import org.structr.core.graph.search.SearchRelationshipCommand;
import org.structr.core.notion.Notion;
import org.structr.core.property.Property;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.exception.NotFoundException;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.SchemaMethodResource;
import org.structr.rest.resource.SortableResource;
import org.structr.rest.resource.TypedIdResource;
import org.structr.rest.resource.UuidResource;
import org.structr.schema.SchemaHelper;

public class TypeResource
extends SortableResource {
    private static final Logger logger = LoggerFactory.getLogger((String)TypeResource.class.getName());
    protected Class<? extends SearchCommand> searchCommandType = null;
    protected ResultTransformer virtualType = null;
    protected Class entityClass = null;
    protected String rawType = null;
    protected HttpServletRequest request = null;
    protected Query query = null;
    protected boolean isNode = true;

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) throws FrameworkException {
        App app = StructrApp.getInstance((SecurityContext)securityContext);
        this.securityContext = securityContext;
        this.request = request;
        this.rawType = part;
        if (this.rawType != null) {
            this.checkVirtualType(app);
            this.entityClass = SchemaHelper.getEntityClassForRawType((String)this.rawType);
            if (this.entityClass != null) {
                if (AbstractRelationship.class.isAssignableFrom(this.entityClass)) {
                    this.searchCommandType = SearchRelationshipCommand.class;
                    this.query = app.relationshipQuery(this.entityClass);
                    this.isNode = false;
                    return true;
                }
                this.searchCommandType = SearchNodeCommand.class;
                this.query = app.nodeQuery(this.entityClass);
                this.isNode = true;
                return true;
            }
        }
        return true;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        boolean includeDeletedAndHidden = true;
        boolean publicOnly = false;
        Object actualSortKey = sortKey;
        boolean actualSortOrder = sortDescending;
        if (this.rawType != null) {
            if (this.entityClass == null) {
                throw new NotFoundException("Type " + this.rawType + " does not exist");
            }
            this.collectSearchAttributes(this.query);
            if (actualSortKey == null) {
                try {
                    GraphObject templateEntity = (GraphObject)this.entityClass.newInstance();
                    PropertyKey sortKeyProperty = templateEntity.getDefaultSortKey();
                    actualSortOrder = "desc".equals(templateEntity.getDefaultSortOrder());
                    actualSortKey = sortKeyProperty != null ? sortKeyProperty : AbstractNode.name;
                }
                catch (Throwable t) {
                    actualSortKey = AbstractNode.name;
                }
            }
            if (this.virtualType != null) {
                Result untransformedResult = this.query.includeDeletedAndHidden(includeDeletedAndHidden).publicOnly(publicOnly).sort(actualSortKey).order(actualSortOrder).offsetId(offsetId).getResult();
                Result result = this.virtualType.transformOutput(this.securityContext, this.entityClass, untransformedResult);
                return PagingHelper.subResult((Result)result, (int)pageSize, (int)page, (String)offsetId);
            }
            return this.query.includeDeletedAndHidden(includeDeletedAndHidden).publicOnly(publicOnly).sort(actualSortKey).order(actualSortOrder).pageSize(pageSize).page(page).offsetId(offsetId).getResult();
        }
        logger.warn("type was null");
        List emptyList = Collections.emptyList();
        return new Result(emptyList, null, this.isCollectionResource(), this.isPrimitiveArray());
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        if (this.virtualType != null) {
            this.virtualType.transformInput(this.securityContext, this.entityClass, propertySet);
        }
        if (this.isNode) {
            RestMethodResult result = new RestMethodResult(201);
            NodeInterface newNode = this.createNode(propertySet);
            if (newNode != null) {
                result.addHeader("Location", this.buildLocationHeader((GraphObject)newNode));
                result.addContent((GraphObject)newNode);
            }
            result.serializeAsPrimitiveArray(true);
            return result;
        }
        App app = StructrApp.getInstance((SecurityContext)this.securityContext);
        Relation template = this.getRelationshipTemplate();
        ErrorBuffer errorBuffer = new ErrorBuffer();
        if (template != null) {
            NodeInterface sourceNode = this.identifyStartNode(template, propertySet);
            NodeInterface targetNode = this.identifyEndNode(template, propertySet);
            PropertyMap properties = PropertyMap.inputTypeToJavaType((SecurityContext)this.securityContext, (Class)this.entityClass, propertySet);
            Relation newRelationship = null;
            if (sourceNode == null) {
                errorBuffer.add((ErrorToken)new EmptyPropertyToken(this.entityClass.getSimpleName(), (PropertyKey)template.getSourceIdProperty()));
            }
            if (targetNode == null) {
                errorBuffer.add((ErrorToken)new EmptyPropertyToken(this.entityClass.getSimpleName(), (PropertyKey)template.getTargetIdProperty()));
            }
            if (errorBuffer.hasError()) {
                throw new FrameworkException(422, "Source node ID and target node ID of relationsips must be set", errorBuffer);
            }
            template.ensureCardinality(this.securityContext, sourceNode, targetNode);
            newRelationship = app.create(sourceNode, targetNode, this.entityClass, properties);
            RestMethodResult result = new RestMethodResult(201);
            if (newRelationship != null) {
                result.addHeader("Location", this.buildLocationHeader((GraphObject)newRelationship));
                result.addContent((GraphObject)newRelationship);
            }
            result.serializeAsPrimitiveArray(true);
            return result;
        }
        throw new NotFoundException("Type" + this.rawType + " does not exist");
    }

    @Override
    public RestMethodResult doPut(Map<String, Object> propertySet) throws FrameworkException {
        throw new IllegalPathException("PUT not allowed on " + this.rawType + " collection resource");
    }

    public NodeInterface createNode(Map<String, Object> propertySet) throws FrameworkException {
        if (this.entityClass != null) {
            App app = StructrApp.getInstance((SecurityContext)this.securityContext);
            PropertyMap properties = PropertyMap.inputTypeToJavaType((SecurityContext)this.securityContext, (Class)this.entityClass, propertySet);
            return app.create(this.entityClass, properties);
        }
        throw new NotFoundException("Type " + this.rawType + " does not exist");
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        if (next instanceof UuidResource) {
            return new TypedIdResource(this.securityContext, (UuidResource)next, this);
        }
        if (next instanceof TypeResource) {
            return new SchemaMethodResource(this.securityContext, this, (TypeResource)next);
        }
        return super.tryCombineWith(next);
    }

    @Override
    public String getUriPart() {
        return this.rawType;
    }

    public String getRawType() {
        return this.rawType;
    }

    @Override
    public Class getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<? extends GraphObject> type) {
        this.entityClass = type;
    }

    public void setSearchCommandType(Class<? extends SearchCommand> searchCommand) {
        this.searchCommandType = searchCommand;
    }

    @Override
    public String getResourceSignature() {
        return SchemaHelper.normalizeEntityName((String)this.getUriPart());
    }

    @Override
    public boolean isCollectionResource() {
        return true;
    }

    @Override
    public boolean isPrimitiveArray() {
        if (this.virtualType != null) {
            return this.virtualType.isPrimitiveArray();
        }
        return false;
    }

    public void collectSearchAttributes(Query query) throws FrameworkException {
        this.extractSearchableAttributes(this.securityContext, this.entityClass, this.request, query);
        this.extractDistanceSearch(this.request, query);
    }

    private Relation getRelationshipTemplate() {
        try {
            return (Relation)this.entityClass.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private NodeInterface identifyStartNode(Relation template, Map<String, Object> properties) throws FrameworkException {
        Property sourceIdProperty = template.getSourceIdProperty();
        Class sourceType = template.getSourceType();
        Notion notion = template.getStartNodeNotion();
        notion.setType(sourceType);
        PropertyKey startNodeIdentifier = notion.getPrimaryPropertyKey();
        if (startNodeIdentifier != null) {
            Object identifierValue = properties.get(startNodeIdentifier.dbName());
            properties.remove(sourceIdProperty.dbName());
            return (NodeInterface)notion.getAdapterForSetter(this.securityContext).adapt(identifierValue);
        }
        return null;
    }

    private NodeInterface identifyEndNode(Relation template, Map<String, Object> properties) throws FrameworkException {
        Property targetIdProperty = template.getTargetIdProperty();
        Class targetType = template.getTargetType();
        Notion notion = template.getEndNodeNotion();
        notion.setType(targetType);
        PropertyKey endNodeIdentifier = notion.getPrimaryPropertyKey();
        if (endNodeIdentifier != null) {
            Object identifierValue = properties.get(endNodeIdentifier.dbName());
            properties.remove(targetIdProperty.dbName());
            return (NodeInterface)notion.getAdapterForSetter(this.securityContext).adapt(identifierValue);
        }
        return null;
    }

    private void checkVirtualType(App app) throws FrameworkException {
        Class virtualTypeClass = StructrApp.getConfiguration().getNodeEntityClass("VirtualType");
        if (virtualTypeClass != null) {
            PropertyKey positionProperty = StructrApp.getConfiguration().getPropertyKeyForJSONName(virtualTypeClass, "position");
            this.virtualType = (ResultTransformer)app.nodeQuery(virtualTypeClass).andName(this.rawType).sort(positionProperty).getFirst();
            if (this.virtualType != null) {
                String sourceType = this.virtualType.getSourceType();
                if (sourceType != null) {
                    this.rawType = sourceType;
                } else {
                    throw new FrameworkException(500, "Invalid virtual type " + this.rawType + ", missing value for sourceType");
                }
            }
        }
    }
}

