/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Result;
import org.structr.core.Value;
import org.structr.core.property.PropertyKey;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.resource.WrappingResource;
import org.structr.schema.SchemaHelper;

public class ViewFilterResource
extends WrappingResource {
    private static final Logger logger = LoggerFactory.getLogger((String)ViewFilterResource.class.getName());
    private static final Pattern uuidPattern = Pattern.compile("[a-fA-F0-9]{32}");
    private String propertyView = null;

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) {
        if (this.wrappedResource == null) {
            this.securityContext = securityContext;
            this.propertyView = part;
            return true;
        }
        return false;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        if (this.wrappedResource != null) {
            return this.wrappedResource.doGet(sortKey, sortDescending, pageSize, page, offsetId);
        }
        throw new IllegalPathException("GET not allowed on " + this.getResourceSignature());
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        if (this.wrappedResource != null) {
            return this.wrappedResource.doPost(propertySet);
        }
        throw new IllegalPathException("POST not allowed on " + this.getResourceSignature());
    }

    @Override
    public void configurePropertyView(Value<String> propertyView) {
        try {
            propertyView.set(this.securityContext, (Object)this.propertyView);
        }
        catch (FrameworkException fex) {
            logger.warn("Unable to configure property view", (Throwable)fex);
        }
    }

    @Override
    public String getResourceSignature() {
        StringBuilder signature = new StringBuilder();
        String signaturePart = this.wrappedResource.getResourceSignature();
        if (signaturePart.contains("/")) {
            String[] parts = StringUtils.split((String)signaturePart, (String)"/");
            Matcher matcher = uuidPattern.matcher("");
            for (String subPart : parts) {
                matcher.reset(subPart);
                if (matcher.matches()) continue;
                signature.append(subPart);
                signature.append("/");
            }
        } else {
            signature.append(signaturePart);
        }
        if (this.propertyView != null) {
            if (!signature.toString().endsWith("/")) {
                signature.append("/");
            }
            signature.append("_");
            signature.append(SchemaHelper.normalizeEntityName((String)this.propertyView));
        }
        return StringUtils.stripEnd((String)signature.toString(), (String)"/");
    }

    public String getPropertyView() {
        return this.propertyView;
    }
}

