/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.servlet;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.RetryException;
import org.structr.common.PagingHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.JsonInput;
import org.structr.core.Result;
import org.structr.core.Services;
import org.structr.core.Value;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.auth.Authenticator;
import org.structr.core.graph.TransactionCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.DateProperty;
import org.structr.core.property.PropertyKey;
import org.structr.rest.RestMethodResult;
import org.structr.rest.common.CsvHelper;
import org.structr.rest.resource.Resource;
import org.structr.rest.service.HttpServiceServlet;
import org.structr.rest.service.StructrHttpServiceConfig;
import org.structr.rest.servlet.ResourceHelper;
import org.structr.rest.servlet.ThreadLocalGson;
import org.structr.schema.parser.DatePropertyParser;

public class CsvServlet
extends HttpServlet
implements HttpServiceServlet {
    private static final Logger logger = LoggerFactory.getLogger((String)CsvServlet.class.getName());
    public static final String DEFAULT_FIELD_SEPARATOR_HEADER_NAME = "X-CSV-Field-Separator";
    public static final String DEFAULT_QUOTE_CHARACTER_HEADER_NAME = "X-CSV-Quote-Character";
    public static final String DEFAULT_PERIODIC_COMMIT_HEADER_NAME = "X-CSV-Periodic-Commit";
    public static final String DEFAULT_PERIODIC_COMMIT_INTERVAL_HEADER_NAME = "X-CSV-Periodic-Commit-Interval";
    public static final char DEFAULT_FIELD_SEPARATOR = ';';
    public static final char DEFAULT_QUOTE_CHARACTER = '\"';
    public static final boolean DEFAULT_PERIODIC_COMMIT = false;
    public static final int DEFAULT_PERIODIC_COMMIT_INTERVAL = 1000;
    public static final char DEFAULT_FIELD_SEPARATOR_COLLECTION_CONTENTS = ',';
    public static final char DEFAULT_QUOTE_CHARACTER_COLLECTION_CONTENTS = '\"';
    private static final String REMOVE_LINE_BREAK_PARAM = "nolinebreaks";
    private static final String WRITE_BOM = "bom";
    private SecurityContext securityContext;
    private final Map<Pattern, Class<? extends Resource>> resourceMap = new LinkedHashMap<Pattern, Class<? extends Resource>>();
    private Value<String> propertyView = null;
    private static boolean removeLineBreaks = false;
    private static boolean writeBom = false;
    private String defaultPropertyView;
    private final StructrHttpServiceConfig config = new StructrHttpServiceConfig();
    private ThreadLocalGson gson = null;

    @Override
    public StructrHttpServiceConfig getConfig() {
        return this.config;
    }

    public void init() {
        this.resourceMap.putAll(this.config.getResourceProvider().getResources());
        this.propertyView = new ThreadLocalPropertyView();
        this.defaultPropertyView = this.config.getDefaultPropertyView();
        this.gson = new ThreadLocalGson(this.propertyView, this.config.getOutputNestingDepth());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        Authenticator authenticator = null;
        Result result = null;
        Resource resource = null;
        try {
            try (Tx tx = StructrApp.getInstance().tx();){
                authenticator = this.config.getAuthenticator();
                this.securityContext = authenticator.initializeAndExamineRequest(request, response);
                tx.success();
            }
            App app = StructrApp.getInstance((SecurityContext)this.securityContext);
            request.setCharacterEncoding("UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/csv; charset=utf-8");
            this.propertyView.set(this.securityContext, (Object)this.defaultPropertyView);
            double queryTimeStart = System.nanoTime();
            try (Tx tx = app.tx();){
                resource = ResourceHelper.optimizeNestedResourceChain(this.securityContext, request, this.resourceMap, this.propertyView);
                authenticator.checkResourceAccess(this.securityContext, request, resource.getResourceSignature(), (String)this.propertyView.get(this.securityContext));
                tx.success();
            }
            tx = app.tx();
            var10_21 = null;
            try {
                String resourceSignature = resource.getResourceSignature();
                authenticator.checkResourceAccess(this.securityContext, request, resourceSignature, (String)this.propertyView.get(this.securityContext));
                String pageSizeParameter = request.getParameter("pageSize");
                String pageParameter = request.getParameter("page");
                String offsetId = request.getParameter("pageStartId");
                String sortOrder = request.getParameter("order");
                String sortKeyName = request.getParameter("sort");
                boolean sortDescending = sortOrder != null && "desc".equals(sortOrder.toLowerCase());
                int pageSize = Services.parseInt((String)pageSizeParameter, (int)Integer.MAX_VALUE);
                int page = Services.parseInt((String)pageParameter, (int)1);
                PropertyKey sortKey = null;
                if (sortKeyName != null) {
                    Class<? extends GraphObject> type = resource.getEntityClass();
                    sortKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(type, sortKeyName, false);
                }
                removeLineBreaks = StringUtils.equals((CharSequence)request.getParameter(REMOVE_LINE_BREAK_PARAM), (CharSequence)"1");
                writeBom = StringUtils.equals((CharSequence)request.getParameter(WRITE_BOM), (CharSequence)"1");
                result = resource.doGet(sortKey, sortDescending, pageSize, page, offsetId);
                if (result != null) {
                    result.setIsCollection(resource.isCollectionResource());
                    result.setIsPrimitiveArray(resource.isPrimitiveArray());
                    PagingHelper.addPagingParameter((Result)result, (int)pageSize, (int)page);
                    double queryTimeEnd = System.nanoTime();
                    result.setPropertyView((String)this.propertyView.get(this.securityContext));
                    resource.postProcessResultSet(result);
                    DecimalFormat decimalFormat = new DecimalFormat("0.000000000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                    result.setQueryTime(decimalFormat.format((queryTimeEnd - queryTimeStart) / 1.0E9));
                    PrintWriter writer = response.getWriter();
                    if (writeBom) {
                        this.writeUtf8Bom(writer);
                    }
                    CsvServlet.writeCsv(result, writer, (String)this.propertyView.get(this.securityContext));
                    response.setStatus(200);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                } else {
                    logger.warn("Result was null!");
                    int code = 204;
                    response.setStatus(code);
                    PrintWriter writer = response.getWriter();
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                tx.success();
            }
            catch (Throwable throwable) {
                var10_21 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var10_21 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var10_21.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (FrameworkException frameworkException) {
            response.setStatus(frameworkException.getStatus());
        }
        catch (JsonSyntaxException jsex) {
            logger.warn("JsonSyntaxException in GET", (Throwable)jsex);
            int code = 400;
            response.setStatus(code);
        }
        catch (JsonParseException jpex) {
            logger.warn("JsonParseException in GET", (Throwable)jpex);
            int code = 400;
            response.setStatus(code);
        }
        catch (Throwable t) {
            logger.warn("Exception in GET", t);
            int code = 500;
            response.setStatus(code);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block116: {
            String fieldSeparatorHeader = request.getHeader(DEFAULT_FIELD_SEPARATOR_HEADER_NAME);
            char fieldSeparator = fieldSeparatorHeader == null ? (char)';' : (char)fieldSeparatorHeader.charAt(0);
            String quoteCharacterHeader = request.getHeader(DEFAULT_QUOTE_CHARACTER_HEADER_NAME);
            char quoteCharacter = quoteCharacterHeader == null ? (char)'\"' : (char)quoteCharacterHeader.charAt(0);
            String doPeridicCommitHeader = request.getHeader(DEFAULT_PERIODIC_COMMIT_HEADER_NAME);
            boolean doPeriodicCommit = doPeridicCommitHeader == null ? false : Boolean.parseBoolean(doPeridicCommitHeader);
            String periodicCommitIntervalHeader = request.getHeader(DEFAULT_PERIODIC_COMMIT_INTERVAL_HEADER_NAME);
            int periodicCommitInterval = periodicCommitIntervalHeader == null ? 1000 : Integer.parseInt(periodicCommitIntervalHeader);
            LinkedList<RestMethodResult> results = new LinkedList<RestMethodResult>();
            try {
                Tx tx;
                Authenticator authenticator;
                request.setCharacterEncoding("UTF-8");
                response.setCharacterEncoding("UTF-8");
                response.setContentType("application/json; charset=utf-8");
                BufferedReader input = request.getReader();
                try (Tx tx2 = StructrApp.getInstance().tx();){
                    authenticator = this.config.getAuthenticator();
                    this.securityContext = authenticator.initializeAndExamineRequest(request, response);
                    tx2.success();
                }
                App app = StructrApp.getInstance((SecurityContext)this.securityContext);
                if (this.securityContext != null) {
                    Tx tx3;
                    Resource resource;
                    tx = app.tx();
                    Throwable throwable = null;
                    try {
                        resource = ResourceHelper.applyViewTransformation(request, this.securityContext, ResourceHelper.optimizeNestedResourceChain(this.securityContext, request, this.resourceMap, this.propertyView), this.propertyView);
                        authenticator.checkResourceAccess(this.securityContext, request, resource.getResourceSignature(), (String)this.propertyView.get(this.securityContext));
                        tx.success();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                    this.securityContext.setDoTransactionNotifications(false);
                    boolean retry = true;
                    while (retry) {
                        retry = false;
                        Iterable<JsonInput> csv = CsvHelper.cleanAndParseCSV(this.securityContext, input, resource.getEntityClass(), fieldSeparator, quoteCharacter);
                        if (resource.createPostTransaction()) {
                            Object chunkedCsv;
                            if (doPeriodicCommit) {
                                ArrayList list = new ArrayList();
                                csv.iterator().forEachRemaining(list::add);
                                chunkedCsv = ListUtils.partition(list, (int)periodicCommitInterval);
                                int totalChunkNo = chunkedCsv.size();
                                int currentChunkNo = 0;
                                Iterator iterator = chunkedCsv.iterator();
                                while (iterator.hasNext()) {
                                    List currentChunk = (List)iterator.next();
                                    try {
                                        Tx tx4 = app.tx();
                                        Throwable throwable4 = null;
                                        try {
                                            ++currentChunkNo;
                                            for (JsonInput propertySet : currentChunk) {
                                                this.handleCsvPropertySet(results, resource, propertySet);
                                            }
                                            tx4.success();
                                            logger.info("CSV: Finished importing chunk " + currentChunkNo + " / " + totalChunkNo);
                                            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                                            data.put("type", "CSV_IMPORT_STATUS");
                                            data.put("title", "CSV Import Status");
                                            data.put("text", "Finished importing chunk " + currentChunkNo + " / " + totalChunkNo);
                                            data.put("username", this.securityContext.getUser(false).getName());
                                            TransactionCommand.simpleBroadcast((String)"GENERIC_MESSAGE", data);
                                        }
                                        catch (Throwable throwable5) {
                                            throwable4 = throwable5;
                                            throw throwable5;
                                        }
                                        finally {
                                            if (tx4 == null) continue;
                                            if (throwable4 != null) {
                                                try {
                                                    tx4.close();
                                                }
                                                catch (Throwable throwable6) {
                                                    throwable4.addSuppressed(throwable6);
                                                }
                                                continue;
                                            }
                                            tx4.close();
                                        }
                                    }
                                    catch (RetryException ddex) {
                                        retry = true;
                                    }
                                }
                                continue;
                            }
                            try {
                                tx3 = app.tx();
                                chunkedCsv = null;
                                try {
                                    for (JsonInput propertySet : csv) {
                                        this.handleCsvPropertySet(results, resource, propertySet);
                                    }
                                    tx3.success();
                                }
                                catch (Throwable totalChunkNo) {
                                    chunkedCsv = totalChunkNo;
                                    throw totalChunkNo;
                                }
                                finally {
                                    if (tx3 == null) continue;
                                    if (chunkedCsv != null) {
                                        try {
                                            tx3.close();
                                        }
                                        catch (Throwable totalChunkNo) {
                                            ((Throwable)chunkedCsv).addSuppressed(totalChunkNo);
                                        }
                                        continue;
                                    }
                                    tx3.close();
                                }
                            }
                            catch (RetryException ddex) {
                                retry = true;
                            }
                            continue;
                        }
                        if (doPeriodicCommit) {
                            logger.warn("Resource auto-creates POST transaction - can not commit periodically!");
                        }
                        try {
                            for (JsonInput propertySet : csv) {
                                this.handleCsvPropertySet(results, resource, propertySet);
                            }
                        }
                        catch (RetryException ddex) {
                            retry = true;
                        }
                    }
                    logger.info("CSV: Finished importing csv data.");
                    LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
                    data.put("type", "CSV_IMPORT_STATUS");
                    data.put("title", "CSV Import Done");
                    data.put("text", "Finished importing csv data.");
                    data.put("username", this.securityContext.getUser(false).getName());
                    TransactionCommand.simpleBroadcast((String)"GENERIC_MESSAGE", data);
                    this.propertyView.set(this.securityContext, (Object)this.config.getDefaultPropertyView());
                    tx3 = app.tx();
                    Throwable throwable7 = null;
                    try {
                        if (!results.isEmpty()) {
                            RestMethodResult result = (RestMethodResult)results.get(0);
                            int resultCount = results.size();
                            if (result != null) {
                                if (resultCount > 1) {
                                    for (RestMethodResult r : results) {
                                        GraphObject objectCreated = r.getContent().get(0);
                                        if (result.getContent().contains(objectCreated)) continue;
                                        result.addContent(objectCreated);
                                    }
                                    result.addHeader("Location", null);
                                }
                                result.commitResponse((Gson)this.gson.get(), response);
                            }
                        }
                        tx3.success();
                        break block116;
                    }
                    catch (Throwable throwable8) {
                        throwable7 = throwable8;
                        throw throwable8;
                    }
                    finally {
                        if (tx3 != null) {
                            if (throwable7 != null) {
                                try {
                                    tx3.close();
                                }
                                catch (Throwable throwable9) {
                                    throwable7.addSuppressed(throwable9);
                                }
                            } else {
                                tx3.close();
                            }
                        }
                    }
                }
                tx = app.tx();
                Throwable throwable = null;
                try {
                    new RestMethodResult(403).commitResponse((Gson)this.gson.get(), response);
                    tx.success();
                }
                catch (Throwable throwable10) {
                    throwable = throwable10;
                    throw throwable10;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable11) {
                                throwable.addSuppressed(throwable11);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            catch (FrameworkException frameworkException) {
                response.setStatus(frameworkException.getStatus());
                ((Gson)this.gson.get()).toJson((Object)frameworkException, (Appendable)response.getWriter());
                response.getWriter().println();
            }
            catch (JsonSyntaxException jsex) {
                logger.warn("POST: Invalid JSON syntax", (Object)jsex.getMessage());
                int code = 400;
                response.setStatus(code);
                response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in POST: " + jsex.getMessage()));
            }
            catch (JsonParseException jpex) {
                logger.warn("Unable to parse JSON string", (Object)jpex.getMessage());
                int code = 400;
                response.setStatus(code);
                response.getWriter().append(RestMethodResult.jsonError(code, "JsonParseException in POST: " + jpex.getMessage()));
            }
            catch (UnsupportedOperationException uoe) {
                logger.warn("POST not supported");
                int code = 400;
                response.setStatus(code);
                response.getWriter().append(RestMethodResult.jsonError(code, "POST not supported: " + uoe.getMessage()));
            }
            catch (Throwable t) {
                logger.warn("Exception in POST", t);
                int code = 500;
                response.setStatus(code);
                response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in POST: " + t.getMessage()));
            }
            finally {
                try {
                    response.getWriter().close();
                }
                catch (Throwable t) {
                    logger.warn("Unable to flush and close response: {}", (Object)t.getMessage());
                }
            }
        }
    }

    public String getModuleName() {
        return "csv";
    }

    private void handleCsvPropertySet(List<RestMethodResult> results, Resource resource, JsonInput propertySet) throws FrameworkException {
        try {
            results.add(resource.doPost(this.convertPropertySetToMap(propertySet)));
        }
        catch (FrameworkException fxe) {
            logger.warn("CSV Import Error: " + fxe.getMessage() + "\n" + fxe.toString() + "\n{}", (Object)propertySet);
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            data.put("type", "CSV_IMPORT_ERROR");
            data.put("title", "CSV Import Error");
            data.put("text", fxe.getMessage() + "<br>" + fxe.toString() + "<br>" + propertySet.toString());
            data.put("username", this.securityContext.getUser(false).getName());
            TransactionCommand.simpleBroadcast((String)"GENERIC_MESSAGE", data);
            throw fxe;
        }
    }

    private static String escapeForCsv(Object value) {
        String result;
        if (value instanceof String[]) {
            ArrayList<String> quotedStrings = new ArrayList<String>();
            for (String str : Arrays.asList((String[])value)) {
                quotedStrings.add("\\\"" + StringUtils.replace((String)str, (String)"\"", (String)"\\\\\\\"") + "\\\"");
            }
            result = quotedStrings.toString();
        } else if (value instanceof Collection) {
            ArrayList<String> quotedStrings = new ArrayList<String>();
            for (Object obj : (Collection)value) {
                quotedStrings.add("\\\"" + obj.toString() + "\\\"");
            }
            result = quotedStrings.toString();
        } else {
            result = value instanceof Date ? DatePropertyParser.format((Date)((Date)value), (String)DateProperty.getDefaultFormat()) : StringUtils.replace((String)value.toString(), (String)"\"", (String)"\\\"");
        }
        if (!removeLineBreaks) {
            return StringUtils.replace((String)StringUtils.replace((String)result, (String)"\r\n", (String)"\n"), (String)"\r", (String)"\n");
        }
        return StringUtils.replace((String)StringUtils.replace((String)result, (String)"\r\n", (String)""), (String)"\r", (String)"");
    }

    private void writeUtf8Bom(Writer out) {
        try {
            out.write("\ufeff");
        }
        catch (IOException ex) {
            logger.warn("Unable to write UTF-8 BOM", (Throwable)ex);
        }
    }

    public static void writeCsv(Result result, Writer out, String propertyView) throws IOException {
        List list = result.getResults();
        StringBuilder row = new StringBuilder();
        boolean headerWritten = false;
        for (GraphObject obj : list) {
            if (!headerWritten) {
                row.setLength(0);
                for (PropertyKey key : obj.getPropertyKeys(propertyView)) {
                    row.append("\"").append(key.dbName()).append("\"").append(';');
                }
                int pos = row.lastIndexOf(";");
                if (pos >= 0) {
                    row.deleteCharAt(pos);
                }
                out.append(row).append("\r\n");
                out.flush();
                headerWritten = true;
            }
            row.setLength(0);
            for (PropertyKey key : obj.getPropertyKeys(propertyView)) {
                Object value = obj.getProperty(key);
                row.append("\"").append(value != null ? CsvServlet.escapeForCsv(value) : "").append("\"").append(';');
            }
            row.deleteCharAt(row.lastIndexOf(";"));
            out.append(row).append("\r\n");
            out.flush();
        }
    }

    private Map<String, Object> convertPropertySetToMap(JsonInput propertySet) {
        if (propertySet != null) {
            return propertySet.getAttributes();
        }
        return new LinkedHashMap<String, Object>();
    }

    private class ThreadLocalPropertyView
    extends ThreadLocal<String>
    implements Value<String> {
        private ThreadLocalPropertyView() {
        }

        @Override
        protected String initialValue() {
            return CsvServlet.this.defaultPropertyView;
        }

        public String get(SecurityContext securityContext) {
            return (String)this.get();
        }

        public void set(SecurityContext securityContext, String value) {
            this.set(value);
        }
    }
}

