/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.servlet;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.structr.api.RetryException;
import org.structr.api.config.Settings;
import org.structr.common.PagingHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.IJsonInput;
import org.structr.core.JsonInput;
import org.structr.core.JsonSingleInput;
import org.structr.core.Result;
import org.structr.core.Services;
import org.structr.core.Value;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.auth.Authenticator;
import org.structr.core.entity.AbstractNode;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.rest.ResourceProvider;
import org.structr.rest.RestMethodResult;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.StaticRelationshipResource;
import org.structr.rest.serialization.StreamingHtmlWriter;
import org.structr.rest.serialization.StreamingJsonWriter;
import org.structr.rest.service.HttpServiceServlet;
import org.structr.rest.service.StructrHttpServiceConfig;
import org.structr.rest.servlet.ResourceHelper;
import org.structr.rest.servlet.ThreadLocalGson;
import org.tuckey.web.filters.urlrewrite.utils.StringUtils;

public class JsonRestServlet
extends HttpServlet
implements HttpServiceServlet {
    public static final int DEFAULT_VALUE_PAGE_SIZE = 20;
    public static final String DEFAULT_VALUE_SORT_ORDER = "asc";
    public static final String REQUEST_PARAMETER_LOOSE_SEARCH = "loose";
    public static final String REQUEST_PARAMETER_PAGE_NUMBER = "page";
    public static final String REQUEST_PARAMETER_PAGE_SIZE = "pageSize";
    public static final String REQUEST_PARAMETER_OFFSET_ID = "pageStartId";
    public static final String REQUEST_PARAMETER_SORT_KEY = "sort";
    public static final String REQUEST_PARAMETER_SORT_ORDER = "order";
    public static final Set<String> commonRequestParameters = new LinkedHashSet<String>();
    private static final Logger logger = LoggerFactory.getLogger((String)JsonRestServlet.class.getName());
    private final Map<Pattern, Class<? extends Resource>> resourceMap = new LinkedHashMap<Pattern, Class<? extends Resource>>();
    private final StructrHttpServiceConfig config = new StructrHttpServiceConfig();
    private Value<String> propertyView = null;
    private ThreadLocalGson gson = null;
    private boolean indentJson = true;

    @Override
    public StructrHttpServiceConfig getConfig() {
        return this.config;
    }

    public void init() {
        ResourceProvider provider = this.config.getResourceProvider();
        if (provider != null) {
            this.resourceMap.putAll(provider.getResources());
        } else {
            logger.error("Unable to initialize JsonRestServlet, no resource provider found. Please check structr.conf for a valid resource provider class.");
        }
        this.propertyView = new ThreadLocalPropertyView();
        this.indentJson = (Boolean)Settings.JsonIndentation.getValue();
        this.gson = new ThreadLocalGson(this.propertyView, this.config.getOutputNestingDepth());
    }

    public String getModuleName() {
        return "core";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SecurityContext securityContext = null;
        Authenticator authenticator = null;
        RestMethodResult result = null;
        Resource resource = null;
        try {
            this.assertInitialized();
            request.setCharacterEncoding("UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json; charset=utf-8");
            try (Tx tx = StructrApp.getInstance().tx();){
                authenticator = this.config.getAuthenticator();
                securityContext = authenticator.initializeAndExamineRequest(request, response);
                tx.success();
            }
            App app = StructrApp.getInstance((SecurityContext)securityContext);
            try (Tx tx = app.tx();){
                resource = ResourceHelper.optimizeNestedResourceChain(securityContext, request, this.resourceMap, this.propertyView);
                authenticator.checkResourceAccess(securityContext, request, resource.getResourceSignature(), (String)this.propertyView.get(securityContext));
                tx.success();
            }
            boolean retry = true;
            while (retry) {
                try {
                    result = resource.doDelete();
                    retry = false;
                }
                catch (RetryException ddex) {
                    retry = true;
                }
            }
            try (Tx tx = app.tx();){
                result.commitResponse((Gson)this.gson.get(), response);
                tx.success();
            }
        }
        catch (FrameworkException frameworkException) {
            response.setStatus(frameworkException.getStatus());
            ((Gson)this.gson.get()).toJson((Object)frameworkException, (Appendable)response.getWriter());
            response.getWriter().println();
        }
        catch (JsonSyntaxException jsex) {
            logger.warn("JsonSyntaxException in DELETE", (Throwable)jsex);
            int code = 400;
            response.setStatus(code);
            response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in DELETE: " + jsex.getMessage()));
        }
        catch (JsonParseException jpex) {
            logger.warn("JsonParseException in DELETE", (Throwable)jpex);
            int code = 400;
            response.setStatus(code);
            response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in DELETE: " + jpex.getMessage()));
        }
        catch (Throwable t) {
            logger.warn("Exception in DELETE", t);
            int code = 500;
            response.setStatus(code);
            response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in DELETE: " + t.getMessage()));
        }
        finally {
            try {
                response.getWriter().close();
            }
            catch (IOException t) {
                logger.warn("Unable to flush and close response: {}", (Object)t.getMessage());
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean returnContent = true;
        this.doGetOrHead(request, response, true);
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean returnContent = false;
        this.doGetOrHead(request, response, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOptions(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RestMethodResult result = new RestMethodResult(400);
        try {
            Throwable throwable;
            Tx tx;
            Resource resource;
            SecurityContext securityContext;
            Authenticator authenticator;
            this.assertInitialized();
            request.setCharacterEncoding("UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json; charset=utf-8");
            try (Tx tx2 = StructrApp.getInstance().tx();){
                authenticator = this.config.getAuthenticator();
                securityContext = authenticator.initializeAndExamineRequest(request, response);
                tx2.success();
            }
            App app = StructrApp.getInstance((SecurityContext)securityContext);
            try (Tx tx3 = app.tx();){
                resource = ResourceHelper.applyViewTransformation(request, securityContext, ResourceHelper.optimizeNestedResourceChain(securityContext, request, this.resourceMap, this.propertyView), this.propertyView);
                authenticator.checkResourceAccess(securityContext, request, resource.getResourceSignature(), (String)this.propertyView.get(securityContext));
                tx3.success();
            }
            boolean retry = true;
            while (retry) {
                try {
                    tx = app.tx();
                    throwable = null;
                    try {
                        result = resource.doOptions();
                        tx.success();
                        retry = false;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (RetryException ddex) {
                    retry = true;
                }
            }
            tx = app.tx();
            throwable = null;
            try {
                result.commitResponse((Gson)this.gson.get(), response);
                tx.success();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (FrameworkException frameworkException) {
            response.setStatus(frameworkException.getStatus());
            ((Gson)this.gson.get()).toJson((Object)frameworkException, (Appendable)response.getWriter());
            response.getWriter().println();
        }
        catch (JsonSyntaxException jsex) {
            logger.warn("JsonSyntaxException in OPTIONS", (Throwable)jsex);
            int code = 400;
            response.setStatus(code);
            response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in OPTIONS: " + jsex.getMessage()));
        }
        catch (JsonParseException jpex) {
            logger.warn("JsonParseException in OPTIONS", (Throwable)jpex);
            int code = 400;
            response.setStatus(code);
            response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in OPTIONS: " + jpex.getMessage()));
        }
        catch (Throwable t) {
            logger.warn("Exception in OPTIONS", t);
            int code = 500;
            response.setStatus(code);
            response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in OPTIONS: " + t.getMessage()));
        }
        finally {
            try {
                response.getWriter().close();
            }
            catch (Throwable t) {
                logger.warn("Unable to flush and close response: {}", (Object)t.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block100: {
            LinkedList<RestMethodResult> results = new LinkedList<RestMethodResult>();
            try {
                SecurityContext securityContext;
                Authenticator authenticator;
                this.assertInitialized();
                request.setCharacterEncoding("UTF-8");
                response.setCharacterEncoding("UTF-8");
                response.setContentType("application/json; charset=utf-8");
                String input = IOUtils.toString((Reader)request.getReader());
                try (Tx tx = StructrApp.getInstance().tx();){
                    authenticator = this.config.getAuthenticator();
                    securityContext = authenticator.initializeAndExamineRequest(request, response);
                    tx.success();
                }
                App app = StructrApp.getInstance((SecurityContext)securityContext);
                IJsonInput jsonInput = this.cleanAndParseJsonString(app, input);
                if (securityContext != null) {
                    Throwable throwable;
                    Tx tx;
                    Resource resource;
                    try (Tx tx2 = app.tx();){
                        resource = ResourceHelper.applyViewTransformation(request, securityContext, ResourceHelper.optimizeNestedResourceChain(securityContext, request, this.resourceMap, this.propertyView), this.propertyView);
                        authenticator.checkResourceAccess(securityContext, request, resource.getResourceSignature(), (String)this.propertyView.get(securityContext));
                        tx2.success();
                    }
                    boolean retry = true;
                    while (retry) {
                        if (resource.createPostTransaction()) {
                            try {
                                tx = app.tx();
                                throwable = null;
                                try {
                                    for (JsonInput propertySet : jsonInput.getJsonInputs()) {
                                        results.add(resource.doPost(this.convertPropertySetToMap(propertySet)));
                                    }
                                    tx.success();
                                    retry = false;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (tx == null) continue;
                                    if (throwable != null) {
                                        try {
                                            tx.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    tx.close();
                                }
                            }
                            catch (RetryException ddex) {
                                retry = true;
                            }
                            continue;
                        }
                        try {
                            for (JsonInput propertySet : jsonInput.getJsonInputs()) {
                                results.add(resource.doPost(this.convertPropertySetToMap(propertySet)));
                            }
                            retry = false;
                        }
                        catch (RetryException ddex) {
                            retry = true;
                        }
                    }
                    this.propertyView.set(securityContext, (Object)this.config.getDefaultPropertyView());
                    tx = app.tx();
                    throwable = null;
                    try {
                        if (!results.isEmpty()) {
                            RestMethodResult result = (RestMethodResult)results.get(0);
                            int resultCount = results.size();
                            if (result != null) {
                                if (resultCount > 1) {
                                    for (RestMethodResult r : results) {
                                        GraphObject objectCreated = r.getContent().get(0);
                                        if (result.getContent().contains(objectCreated)) continue;
                                        result.addContent(objectCreated);
                                    }
                                    result.addHeader("Location", null);
                                }
                                result.commitResponse((Gson)this.gson.get(), response);
                            }
                        }
                        tx.success();
                        break block100;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                }
                try (Tx tx = app.tx();){
                    new RestMethodResult(403).commitResponse((Gson)this.gson.get(), response);
                    tx.success();
                }
            }
            catch (FrameworkException frameworkException) {
                response.setStatus(frameworkException.getStatus());
                ((Gson)this.gson.get()).toJson((Object)frameworkException, (Appendable)response.getWriter());
                response.getWriter().println();
            }
            catch (JsonSyntaxException jsex) {
                logger.warn("POST: Invalid JSON syntax", (Object)jsex.getMessage());
                int code = 400;
                response.setStatus(code);
                response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in POST: " + jsex.getMessage()));
            }
            catch (JsonParseException jpex) {
                logger.warn("Unable to parse JSON string", (Object)jpex.getMessage());
                int code = 400;
                response.setStatus(code);
                response.getWriter().append(RestMethodResult.jsonError(code, "JsonParseException in POST: " + jpex.getMessage()));
            }
            catch (UnsupportedOperationException uoe) {
                logger.warn("POST not supported");
                int code = 400;
                response.setStatus(code);
                response.getWriter().append(RestMethodResult.jsonError(code, "POST not supported: " + uoe.getMessage()));
            }
            catch (Throwable t) {
                logger.warn("Exception in POST", t);
                int code = 500;
                response.setStatus(code);
                response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in POST: " + t.getMessage()));
            }
            finally {
                try {
                    response.getWriter().close();
                }
                catch (Throwable t) {
                    logger.warn("Unable to flush and close response: {}", (Object)t.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block87: {
            RestMethodResult result = new RestMethodResult(400);
            try {
                SecurityContext securityContext;
                Authenticator authenticator;
                this.assertInitialized();
                request.setCharacterEncoding("UTF-8");
                response.setCharacterEncoding("UTF-8");
                response.setContentType("application/json; charset=utf-8");
                String input = IOUtils.toString((Reader)request.getReader());
                try (Tx tx = StructrApp.getInstance().tx();){
                    authenticator = this.config.getAuthenticator();
                    securityContext = authenticator.initializeAndExamineRequest(request, response);
                    tx.success();
                }
                App app = StructrApp.getInstance((SecurityContext)securityContext);
                IJsonInput jsonInput = this.cleanAndParseJsonString(app, input);
                if (securityContext != null) {
                    Throwable throwable;
                    Tx tx;
                    Resource resource;
                    try (Tx tx2 = app.tx();){
                        resource = ResourceHelper.applyViewTransformation(request, securityContext, ResourceHelper.optimizeNestedResourceChain(securityContext, request, this.resourceMap, this.propertyView), this.propertyView);
                        authenticator.checkResourceAccess(securityContext, request, resource.getResourceSignature(), (String)this.propertyView.get(securityContext));
                        tx2.success();
                    }
                    boolean retry = true;
                    while (retry) {
                        try {
                            tx = app.tx();
                            throwable = null;
                            try {
                                result = resource.doPut(this.convertPropertySetToMap((JsonInput)jsonInput.getJsonInputs().get(0)));
                                tx.success();
                                retry = false;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (tx == null) continue;
                                if (throwable != null) {
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                tx.close();
                            }
                        }
                        catch (RetryException ddex) {
                            retry = true;
                        }
                    }
                    tx = app.tx();
                    throwable = null;
                    try {
                        result.commitResponse((Gson)this.gson.get(), response);
                        tx.success();
                        break block87;
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (tx != null) {
                            if (throwable != null) {
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                tx.close();
                            }
                        }
                    }
                }
                try (Tx tx = app.tx();){
                    result = new RestMethodResult(403);
                    result.commitResponse((Gson)this.gson.get(), response);
                    tx.success();
                }
            }
            catch (FrameworkException frameworkException) {
                response.setStatus(frameworkException.getStatus());
                ((Gson)this.gson.get()).toJson((Object)frameworkException, (Appendable)response.getWriter());
                response.getWriter().println();
            }
            catch (JsonSyntaxException jsex) {
                logger.warn("PUT: Invalid JSON syntax", (Object)jsex.getMessage());
                int code = 400;
                response.setStatus(code);
                response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in PUT: " + jsex.getMessage()));
            }
            catch (JsonParseException jpex) {
                logger.warn("PUT: Unable to parse JSON string", (Object)jpex.getMessage());
                int code = 400;
                response.setStatus(code);
                response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in PUT: " + jpex.getMessage()));
            }
            catch (Throwable t) {
                logger.warn("Exception in PUT", t);
                logger.warn("", t);
                int code = 500;
                response.setStatus(code);
                response.getWriter().append(RestMethodResult.jsonError(code, "JsonSyntaxException in PUT: " + t.getMessage()));
            }
            finally {
                try {
                    response.getWriter().close();
                }
                catch (Throwable t) {
                    logger.warn("Unable to flush and close response: {}", (Object)t.getMessage());
                }
            }
        }
    }

    protected void doTrace(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json; charset=UTF-8");
        response.setCharacterEncoding("UTF-8");
        int code = 405;
        response.setStatus(code);
        response.getWriter().append(RestMethodResult.jsonError(code, "TRACE method not allowed"));
    }

    private IJsonInput cleanAndParseJsonString(App app, String input) throws FrameworkException {
        Throwable throwable;
        Tx tx;
        IJsonInput jsonInput = null;
        try {
            tx = app.tx();
            throwable = null;
            try {
                jsonInput = (IJsonInput)((Gson)this.gson.get()).fromJson(input, IJsonInput.class);
                tx.success();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx != null) {
                    if (throwable != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (JsonSyntaxException jsx) {
            logger.warn("", (Throwable)jsx);
            throw new FrameworkException(400, jsx.getMessage());
        }
        if (jsonInput == null) {
            if (StringUtils.isBlank((String)input)) {
                tx = app.tx();
                throwable = null;
                try {
                    jsonInput = (IJsonInput)((Gson)this.gson.get()).fromJson("{}", IJsonInput.class);
                    tx.success();
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (tx != null) {
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            } else {
                jsonInput = new JsonSingleInput();
            }
        }
        return jsonInput;
    }

    private Map<String, Object> convertPropertySetToMap(JsonInput propertySet) {
        if (propertySet != null) {
            return propertySet.getAttributes();
        }
        return new LinkedHashMap<String, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetOrHead(HttpServletRequest request, HttpServletResponse response, boolean returnContent) throws ServletException, IOException {
        SecurityContext securityContext = null;
        Authenticator authenticator = null;
        Result result = null;
        Resource resource = null;
        try {
            request.setCharacterEncoding("UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/json; charset=utf-8");
            try (Tx tx = StructrApp.getInstance().tx();){
                authenticator = this.config.getAuthenticator();
                securityContext = authenticator.initializeAndExamineRequest(request, response);
                tx.success();
            }
            App app = StructrApp.getInstance((SecurityContext)securityContext);
            this.propertyView.set(securityContext, (Object)this.config.getDefaultPropertyView());
            double queryTimeStart = System.nanoTime();
            try (Tx tx = app.tx();){
                resource = ResourceHelper.applyViewTransformation(request, securityContext, ResourceHelper.optimizeNestedResourceChain(securityContext, request, this.resourceMap, this.propertyView), this.propertyView);
                authenticator.checkResourceAccess(securityContext, request, resource.getResourceSignature(), (String)this.propertyView.get(securityContext));
                tx.success();
            }
            String pageSizeParameter = request.getParameter(REQUEST_PARAMETER_PAGE_SIZE);
            String pageParameter = request.getParameter(REQUEST_PARAMETER_PAGE_NUMBER);
            String offsetId = request.getParameter(REQUEST_PARAMETER_OFFSET_ID);
            String sortOrder = request.getParameter(REQUEST_PARAMETER_SORT_ORDER);
            String sortKeyName = request.getParameter(REQUEST_PARAMETER_SORT_KEY);
            boolean sortDescending = sortOrder != null && "desc".equals(sortOrder.toLowerCase());
            int pageSize = Services.parseInt((String)pageSizeParameter, (int)Integer.MAX_VALUE);
            int page = Services.parseInt((String)pageParameter, (int)1);
            String baseUrl = request.getRequestURI();
            PropertyKey sortKey = null;
            if (sortKeyName != null) {
                Class<? extends GraphObject> type = resource.getEntityClass();
                if (type == null) {
                    type = AbstractNode.class;
                }
                sortKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(type, sortKeyName, false);
            }
            boolean retry = true;
            while (retry) {
                try {
                    Tx tx = app.tx();
                    Throwable throwable = null;
                    try {
                        result = resource.doGet(sortKey, sortDescending, pageSize, page, offsetId);
                        tx.success();
                        retry = false;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (tx == null) continue;
                        if (throwable != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        tx.close();
                    }
                }
                catch (RetryException ddex) {
                    retry = true;
                }
            }
            if (returnContent) {
                if (!(resource instanceof StaticRelationshipResource || result.isPrimitiveArray() || result.isEmpty())) {
                    result.setIsCollection(resource.isCollectionResource());
                    result.setIsPrimitiveArray(resource.isPrimitiveArray());
                }
                PagingHelper.addPagingParameter(result, (int)pageSize, (int)page);
                double queryTimeEnd = System.nanoTime();
                result.setPropertyView((String)this.propertyView.get(securityContext));
                resource.postProcessResultSet(result);
                DecimalFormat decimalFormat = new DecimalFormat("0.000000000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                result.setQueryTime(decimalFormat.format((queryTimeEnd - queryTimeStart) / 1.0E9));
                String accept = request.getHeader("Accept");
                if (accept != null && accept.contains("text/html")) {
                    StreamingHtmlWriter htmlStreamer = new StreamingHtmlWriter(this.propertyView, this.indentJson, this.config.getOutputNestingDepth());
                    try (Tx tx = app.tx();){
                        response.setContentType("text/html; charset=utf-8");
                        PrintWriter writer = response.getWriter();
                        htmlStreamer.stream(securityContext, writer, result, baseUrl);
                        ((Writer)writer).append("\n");
                        tx.success();
                    }
                }
                StreamingJsonWriter jsonStreamer = new StreamingJsonWriter(this.propertyView, this.indentJson, this.config.getOutputNestingDepth());
                try (Tx tx = app.tx();){
                    response.setContentType("application/json; charset=utf-8");
                    PrintWriter writer = response.getWriter();
                    jsonStreamer.stream(securityContext, writer, result, baseUrl);
                    ((Writer)writer).append("\n");
                    tx.success();
                }
            }
            response.setStatus(200);
        }
        catch (FrameworkException frameworkException) {
            response.setStatus(frameworkException.getStatus());
            ((Gson)this.gson.get()).toJson((Object)frameworkException, (Appendable)response.getWriter());
            response.getWriter().println();
        }
        catch (JsonSyntaxException jsex) {
            logger.warn("JsonSyntaxException in GET", (Throwable)jsex);
            int code = 400;
            response.setStatus(code);
            response.getWriter().append(RestMethodResult.jsonError(code, "Json syntax exception in GET: " + jsex.getMessage()));
        }
        catch (JsonParseException jpex) {
            logger.warn("JsonParseException in GET", (Throwable)jpex);
            int code = 400;
            response.setStatus(code);
            response.getWriter().append(RestMethodResult.jsonError(code, "Parser exception in GET: " + jpex.getMessage()));
        }
        catch (Throwable t) {
            logger.warn("Exception in GET (URI: {})", (Object)(securityContext != null ? securityContext.getCompoundRequestURI() : "(null SecurityContext)"));
            logger.warn(" => Error thrown: ", t);
            int code = 500;
            response.setStatus(code);
            response.getWriter().append(RestMethodResult.jsonError(code, "Exception in GET: " + t.getMessage()));
        }
        finally {
            try {
                response.getWriter().close();
            }
            catch (Throwable t) {
                logger.warn("Unable to flush and close response: {}", (Object)t.getMessage());
            }
        }
    }

    private void assertInitialized() throws FrameworkException {
        if (!Services.getInstance().isInitialized()) {
            throw new FrameworkException(503, "System is not initialized yet.");
        }
    }

    static {
        commonRequestParameters.add(REQUEST_PARAMETER_LOOSE_SEARCH);
        commonRequestParameters.add(REQUEST_PARAMETER_PAGE_NUMBER);
        commonRequestParameters.add(REQUEST_PARAMETER_PAGE_SIZE);
        commonRequestParameters.add(REQUEST_PARAMETER_OFFSET_ID);
        commonRequestParameters.add(REQUEST_PARAMETER_SORT_KEY);
        commonRequestParameters.add(REQUEST_PARAMETER_SORT_ORDER);
        commonRequestParameters.add("debugLoggingEnabled");
        commonRequestParameters.add("ignoreResultCount");
        commonRequestParameters.add("distance");
        commonRequestParameters.add("latlon");
        commonRequestParameters.add("location");
        commonRequestParameters.add("street");
        commonRequestParameters.add("house");
        commonRequestParameters.add("postalCode");
        commonRequestParameters.add("city");
        commonRequestParameters.add("state");
        commonRequestParameters.add("country");
    }

    private class ThreadLocalPropertyView
    extends ThreadLocal<String>
    implements Value<String> {
        private ThreadLocalPropertyView() {
        }

        @Override
        protected String initialValue() {
            return JsonRestServlet.this.config.getDefaultPropertyView();
        }

        public void set(SecurityContext securityContext, String value) {
            this.set(value);
        }

        public String get(SecurityContext securityContext) {
            return (String)this.get();
        }
    }
}

